@extends('Template::layouts.frontend')
@section('content')
    <section class="py-120 account-section">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-7">
                    <form class="account-form disableSubmission" action="{{ route('user.data.submit') }}" method="POST">
                        @csrf
                        <div class="row gy-4 mb-4">
                            <div class="col-md-12">
                                <label class="form-label" class="form--label">@lang('Username')</label>
                                <input class="form--control checkUser" name="username" type="text"
                                    value="{{ old('username') }}" autocomplete="off" required>
                                <small class="text--danger fs-12 usernameExist"></small>
                            </div>
                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label for="" class="form--label">Country</label>
                                <select class="select form--control select2" name="country" required>
                                    @foreach ($countries as $key => $country)
                                        <option data-mobile_code="{{ $country->dial_code }}" data-code="{{ $key }}"
                                            value="{{ $country->country }}">
                                            {{ __($country->country) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label for="" class="form--label">@lang('Number')</label>
                                <div class="input-group">
                                    <span class="input-group-text mobile-code"></span>
                                    <input name="mobile_code" type="hidden">
                                    <input name="country_code" type="hidden">
                                    <input class="form--control form-control checkUser" name="mobile" type="number"
                                        value="{{ old('mobile') }}" required>
                                </div>
                                <small class="text--danger mobileExist"></small>
                            </div>

                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label for="address" class="form--label">@lang('Address')</label>
                                <input class="form--control" name="address" type="text" value="{{ old('address') }}"
                                    autocomplete="off">
                            </div>
                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label for="address" class="form--label">@lang('State')</label>
                                <input class="form--control" name="state" type="text" value="{{ old('state') }}"
                                    autocomplete="off">
                            </div>
                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label for="address" class="form--label">@lang('Zip Code')</label>
                                <input class="form--control" name="zip" type="text" value="{{ old('zip') }}"
                                    autocomplete="off">
                            </div>
                            <div class="col-sm-6 col-lg-12 col-xl-6">
                                <label class="form--label" for="address">@lang('City')</label>
                                <input class="form--control" name="city" type="text" value="{{ old('city') }}"
                                    autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn--base w-100">@lang('Submit')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('style-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {

            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif

            $('.select2').select2();

            $('select[name=country]').on('change', function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
                var value = $('[name=mobile]').val();
                var name = 'mobile';
                checkUser(value, name);
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));


            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name')
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '{{ route('user.checkUser') }}';
                var token = '{{ csrf_token() }}';

                if (name == 'mobile') {
                    var mobile = `${value}`;
                    var data = {
                        mobile: mobile,
                        mobile_code: $('.mobile-code').text().substr(1),
                        _token: token
                    }
                }
                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
@endpush
