@extends('Template::layouts.' . $layout)
@section('content')

    @if ($layout == 'frontend')
        <div class="container py-60">
    @endif

    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card custom--card">
                <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
                    <h6 class="text-white mb-0">
                        @php echo $myTicket->statusBadge; @endphp
                        [@lang('Ticket')#{{ $myTicket->ticket }}] {{ $myTicket->subject }}
                    </h6>
                    @if ($myTicket->status != Status::TICKET_CLOSE && $myTicket->user)
                        <button class="ticket-close-btn confirmationBtn" data-question="@lang('Are you sure to close this ticket?')"
                            data-action="{{ route('ticket.close', $myTicket->id) }}" type="button">
                            <i class="la la-times"></i>
                        </button>
                    @endif
                </div>
                <div class="card-body">
                    <form class="contact-form disableSubmission" method="post"
                        action="{{ route('ticket.reply', $myTicket->id) }}" enctype="multipart/form-data">
                        @csrf
                        <div class="row justify-content-between">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea class="form--control" name="message" rows="4" required>{{ old('message') }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-9">
                                <button class="btn btn--warning btn--sm addAttachment mb-2" type="button">
                                    <i class="fas fa-plus"></i> @lang('Add Attachment')
                                </button>
                                <p class="mb-2">
                                    <span class="text--info fs-14">@lang('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx')</span>
                                </p>
                                <div class="row fileUploadsContainer">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn--base btn--sm w-100 my-2" type="submit">
                                    <i class="la la-fw la-lg la-reply"></i> @lang('Reply')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="support-ticket-list mt-4">
                @forelse($messages as $message)
                    @if ($message->admin_id == 0)
                        <div class="support-ticket mb-4">
                            <div class="flex-align gap-3 mb-2">
                                <h6 class="support-ticket-name">{{ $message?->ticket->fullname }}</h6>
                                <p class="support-ticket-date">
                                    @lang('Posted on') {{ showDateTime($message?->created_at, 'l, dS F Y @ h:i a') }}
                                </p>
                            </div>
                            <p class="support-ticket-message">{{ $message?->message }}</p>
                            @if ($message?->attachments->count() > 0)
                                <div class="support-ticket-file mt-2">
                                    @foreach ($message->attachments as $k => $image)
                                        <a class="text--base" href="{{ route('ticket.download', encrypt($image->id)) }}"
                                            class="me-3">
                                            <span class="icon"><i class="la la-file-download"></i></span>
                                            @lang('Attachment') {{ ++$k }}
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="support-ticket mb-4 admin-message">
                            <div class="flex-align gap-3 mb-2">
                                <h6 class="support-ticket-name">{{ $message?->admin?->name }}</h6>
                                <p class="support-ticket-date">
                                    @lang('Posted on') {{ showDateTime($message?->created_at, 'l, dS F Y @ h:i a') }}
                                </p>
                            </div>
                            <p class="support-ticket-message">{{ $message?->message }}</p>
                            @if ($message?->attachments?->count() > 0)
                                <div class="support-ticket-file mt-2">
                                    @foreach ($message?->attachments as $k => $image)
                                        <a class="text--base" href="{{ route('ticket.download', encrypt($image->id)) }}"
                                            class="me-3">
                                            <span class="icon"><i class="la la-file-download"></i></span>
                                            @lang('Attachment') {{ ++$k }}
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endif
                @empty
                    <div class="empty-message text-center">
                        <img src="{{ asset('assets/images/empty_list.png') }}" alt="empty">
                        <h5 class="text-muted">@lang('No replies found here!')</h5>
                    </div>
                @endforelse
            </div>

        </div>
    </div>
    @if ($layout == 'frontend')
        </div>
    @endif

    <x-confirmation-modal />
@endsection

@push('style')
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }

        .reply-bg {
            background-color: #ffd96729;
        }

        .empty-message img {
            width: 120px;
            margin-bottom: 15px;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled', true)
                }
                $(".fileUploadsContainer").append(`
                <div class="col-lg-6 col-md-12 removeFileInput">
                    <div class="form-group">
                        <div class="input-group">
                            <input type="file" name="attachments[]" class="form--control form-control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                            <button type="button" class="input-group-text text-white removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                        </div>
                    </div>
                </div>
            `)
            });
            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').removeAttr('disabled', true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
@endpush
