@extends('Template::layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        {{ __($pageTitle) }}
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>
                    <table class="table support-table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Subject')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Priority')</th>
                                <th>@lang('Last Reply')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($supports as $support)
                                <tr>
                                    <td> <a class="text--base fw-bold" href="{{ route('ticket.view', $support->ticket) }}">
                                            [@lang('Ticket')#{{ $support->ticket }}] {{ __($support->subject) }} </a></td>
                                    <td>
                                        @php echo $support->statusBadge; @endphp
                                    </td>
                                    <td>
                                        @php echo $support->statusPriority; @endphp
                                    </td>
                                    <td>{{ diffForHumans($support->last_reply) }} </td>

                                    <td>
                                        <a class="btn btn--base btn--sm"
                                            href="{{ route('ticket.view', $support->ticket) }}">
                                            <i class="las la-desktop"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">
                                        @include('Template::partials.empty', [
                                            'message' => 'Support ticket not found!',
                                        ])
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                @if ($supports->hasPages())
                    <div class="pt-3">
                        {{ paginateLinks($supports) }}
                    </div>
                @endif

            </div>
        </div>
    </div>
@endsection
