@extends('Template::layouts.master')
@section('content')
    <section>
        <div class="row gy-4">
            <div class="col-md-12">
                <div class="account-form">
                    <h4 class="mb-1">@lang('Refer & Enjoy the Bonus')</h4>
                    <p class="mb-3">@lang('You\'ll get commission against your referral\'s activities. Level has been decided by the') <strong class="text--base"><i>{{ __(gs('site_name')) }}</i></strong> @lang('authority. If you reach the level, you\'ll get commission.')
                    </p>
                    <div class="copy-link">
                        <div class="input-group">
                            <input class="copyURL form-control form--control" type="text"
                                value="{{ route('home') }}?reference={{ auth()->user()->username }}" readonly>
                            <span class="copyBoard input-group-text btn btn--base" id="copyBoard"><i class="las la-copy"></i> <strong
                                    class="copyText">@lang('Copy')</strong></span>
                        </div>
                    </div>
                </div>
                @if ($user->allReferrals->count() > 0 && $maxLevel > 0)
                    <div class="card custom--card mt-4">
                        <div class="card-body">
                            <div class="treeview-container">
                                <ul class="treeview">
                                    <li class="items-expanded"> {{ $user->fullname }} ( {{ $user->username }} )
                                        @include('Template::partials.under_tree', ['user' => $user,'layer' => 0, 'isFirst' => true])
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
@endsection

@push('style')
    <link type="text/css" href="{{ asset('assets/global/css/jquery.tree_view.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script src="{{ asset('assets/global/js/jquery.tree_view.js') }}"></script>
    <script>
        (function($) {
            "use strict"
            $('.treeview').treeView();
            $('.copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
            });
        })(jQuery);
    </script>
@endpush
