@extends('Template::layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <form id="project-status">
                    <div class="row gy-3 mb-4">
                        <div class="col-sm-6">
                            <div class="input-group">
                                <input class="form-control form--control" name="search" type="search"
                                    value="{{ request()->search }}" placeholder="@lang('Search by transactions')">
                                <button class="input-group-text bg--base">
                                    <i class="las la-search"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="input-group">
                                <select class="form-select form--control select2" name="is_dispatch"
                                    data-minimum-results-for-search="-1">
                                    <option value="">@lang('All')</option>
                                    <option value="0" @selected(request()->is_dispatch != null && request()->is_dispatch == 0)>@lang('Waiting on Harvest / Production')</option>
                                    <option value="1" @selected(request()->is_dispatch == 1)>@lang('Project Dispatched')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        {{ __($pageTitle) }}
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Project')</th>
                                <th>@lang('Trx')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Harvest From')</th>
                                <th>@lang('Return')</th>
                                <th>@lang('Received')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($invests as $invest)
                                <tr>
                                    <td>
                                        @php
                                            $nextTime = \Carbon\Carbon::parse($invest->next_time);
                                            $onHarvest = $invest->project->harvest_date >= now();
                                        @endphp
                                        <span
                                            @if ($onHarvest) data-bs-toggle="tooltip" title="@lang('Interest payments will begin on :date (End of Harvest) once the project has been dispatched by the author.', ['date' => showDateTime($invest->project->harvest_date, 'd F, Y')])" @endif>
                                            @if ($onHarvest)
                                                <a href="{{ route('project.explore', $invest->project->slug) }}"
                                                    class="text--base" @disabled(true)><i
                                                        class="las la-external-link-alt"></i></a>
                                            @endif
                                            {{ __($invest->project->name) }}
                                            <br>
                                            <i class="las la-angle-double-right"></i> @lang('Invest Qty'):
                                            {{ $invest->quantity }}
                                        </span>
                                    </td>
                                    <td>{{ __($invest->trx) }} </td>
                                    <td>{{ showAmount($invest->amount) }} </td>
                                    <td>
                                        <span>
                                            {{ convertHarvestTime($invest->project->harvest_time) }}
                                            <br>
                                            {{ showDateTime($invest->project->harvest_date, 'd-M-y') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>
                                            @if ($invest->project->is_dispatch)
                                                {{ showAmount($invest->interest) }} @lang('every')
                                                {{ $invest->time_name }}
                                                <br>
                                                @lang('for')
                                            @else
                                                @lang('Return')
                                            @endif

                                            @if ($invest->period == '-1')
                                                @lang('Lifetime')
                                            @else
                                                {{ $invest->period }}
                                                {{ $invest->time_name }}
                                            @endif
                                            @if ($invest->capital_status == '1')
                                                + @lang('Capital')
                                            @endif
                                        </span>
                                    </td>
                                    <td>
                                        {{ $invest->return_rec_time }} @lang('times')
                                    </td>
                                    <td>
                                        <a class="btn btn-sm btn--base btn--sm"
                                            href="{{ route('user.invest.details', encrypt($invest->id)) }}">
                                            <i class="las la-desktop"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">
                                        @include('Template::partials.empty', [
                                            'message' => 'Investment record not found!',
                                        ])
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    @if ($invests->hasPages())
                        <div class="pt-3">
                            {{ paginateLinks($invests) }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $('[name=is_dispatch]').on('change', function() {
                $('#project-status').submit();
            });
        })(jQuery);
    </script>
@endpush
