@extends('Template::layouts.master')
@section('content')
    <div class="container">
        <div class="row gy-4">
            <div class="col-12">
                <div class="card custom--card">
                    <div class="card-header">
                        <h5 class="title mb-0">@lang('Project Information')</h5>
                    </div>
                    <div class="card-body">
                        @php
                            $project = $invest->project;
                            $onHarvest = $invest->project->harvest_date >= now();
                        @endphp



                        <div class="row">
                            <div class="col-md-6">
                                <ul class="list-group main-project">
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-paper-plane"></i></span>
                                            @lang('Project Name')
                                        </div>
                                        <span>{{ __($project->name) }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-hand-holding-usd"></i></span>
                                            @lang('Interest')
                                        </div>
                                        <span>
                                            @if ($project->interest_type != Status::PERCENTAGE)
                                                {{ showAmount($project->fixed_interest) }}
                                            @elseif($project->is_dispatch)
                                                {{ showAmount($project->reserved_interest, currencyFormat: false) }}%
                                            @else
                                                {{ showAmount($project->minimum_interest, currencyFormat: false) }}% -
                                                {{ showAmount($project->maximum_interest, currencyFormat: false) }}%
                                            @endif
                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="lab la-audible"></i></span>
                                            @lang('Target Quantity')
                                        </div>
                                        <span>{{ $project->total_quantity }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-bullseye"></i></span>
                                            @lang('Project Goal')
                                        </div>
                                        <span>{{ showAmount($project->investment) }}</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <ul class="list-group">
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-sort-numeric-down"></i></span>
                                            @lang('Invest Min Quantity')
                                        </div>
                                        <span>{{ $project->minimum_quantity }} @lang('Pcs')</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-sort-numeric-up"></i></span>
                                            @lang('Invest Max Quantity')
                                        </div>
                                        <span>{{ $project->maximum_quantity }} @lang('Pcs')</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-redo-alt"></i></span>
                                            @lang('Repeat Time')
                                        </div>
                                        <span>
                                            @if ($project->repeat_time)
                                                {{ $project->repeat_time }} @lang('times')
                                            @else
                                                @lang('Lifetime')
                                            @endif
                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <div>
                                            <span class="text--base"><i class="las la-eye"></i></span>
                                            @lang('Status')
                                        </div>
                                        @php
                                            echo $project->statusBadge;
                                        @endphp
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card custom--card">
                    <div class="card-header">
                        <h5 class="title mb-0">@lang('Basic Information')</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group">

                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-cart-plus"></i></span>
                                    @lang('Invest Qty')
                                </div>
                                <span>{{ $invest->quantity }} @lang('Pcs')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-file-invoice-dollar"></i></span>
                                    @lang('Investment')
                                </div>
                                <span>{{ showAmount($invest->amount) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-calendar-week"></i></span>
                                    @lang('Invest Date')
                                </div>
                                <small>{{ showDateTime($invest->created_at) }}</small>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-hand-holding-usd"></i></span>
                                    @lang('Received Interest')
                                </div>
                                <span>{{ showAmount($invest->interest) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-handshake"></i></span>
                                    @lang('Interval')
                                </div>
                                <small>@lang('Every ') {{ $invest->time_name }}</small>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-eye"></i></span>
                                    @lang('Status')
                                </div>
                                <span>
                                    @if ($invest->status == Status::INVEST_RUNNING)
                                        <span class="badge badge--success">@lang('Running')</span>
                                    @elseif($invest->status == Status::INVEST_CANCELLED)
                                        <span class="badge badge--danger">@lang('Canceled')</span>
                                    @else
                                        <span class="badge badge--info">@lang('Completed')</span>
                                    @endif
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class=" col-md-6">
                <div class="card custom--card">
                    <div class="card-header">
                        <h5 class="title mb-0">@lang('Other Information')</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-hand-holding-usd"></i></span>
                                    @lang('Total Payable')
                                </div>
                                <span>
                                    @if ($invest->period != -1)
                                        {{ $invest->period }} @lang(' times')
                                    @else
                                        @lang('Lifetime')
                                    @endif
                                </span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-wallet"></i></span>
                                    @lang('Total Paid')
                                </div>
                                <span>{{ $invest->return_rec_time }} @lang(' times')</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-money-bill-wave-alt"></i></span>
                                    @lang('Paid Amount')
                                </div>
                                <span>{{ showAmount($invest->paid) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-money-check"></i></span>
                                    @lang('Should Pay')
                                </div>
                                <span>
                                    @if ($invest->project->is_dispatch == Status::INTEREST_DISPATCH)
                                        @if ($invest->should_pay != -1)
                                            {{ showAmount($invest->should_pay) }}
                                        @else
                                            **
                                        @endif
                                    @else
                                        <span class="badge badge--base"> @lang('On Production')</span>
                                    @endif
                                </span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-calendar-check"></i></span>
                                    @lang('Last Paid Time') @if ($onHarvest)
                                        <span> <i class="las la-info-circle" data-bs-toggle="tooltip"
                                                title="@lang('Interest payments will begin on :date (End of Harvest) once the project has been dispatched by the author.', ['date' => showDateTime($invest->project->harvest_date, 'd F, Y')])"></i> </span>
                                    @endif
                                </div>
                                <span>{{ showDateTime($invest->last_time) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <div>
                                    <span class="text--base"><i class="las la-history"></i></span>
                                    @lang('Next Pay Time') @if ($onHarvest)
                                        <span> <i class="las la-info-circle" data-bs-toggle="tooltip"
                                                title="@lang('Interest payments will begin on :date (End of Harvest) once the project has been dispatched by the author.', ['date' => showDateTime($invest->project->harvest_date, 'd F, Y')])"></i> </span>
                                    @endif
                                </div>
                                <span>{{ showDateTime($invest->next_time) }}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>


        <div class="table-wrapper table--lg mt-4">
            <h5 class="table-wrapper__title">
                @lang('Interests Overview')
                <span class="title-border">
                    <span class="box"></span>
                </span>
            </h5>
            <table class="table table--responsive--xl">
                <thead>
                    <tr>
                        <th>@lang('Trx')</th>
                        <th>@lang('Transend at')</th>
                        <th>@lang('Amount')</th>
                        <th>@lang('Post Balance')</th>
                        <th>@lang('Details')</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transactions as $transaction)
                        <tr>
                            <td>{{ __($transaction->trx) }} </td>
                            <td>{{ showDateTime($transaction->created_at) }} </td>
                            <td>{{ showAmount($transaction->amount) }} </td>
                            <td>{{ showAmount($transaction->post_balance) }} </td>
                            <td>{{ __($transaction->details) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td class="text-center" colspan="100%">
                                @include('Template::partials.empty', [
                                    'message' => 'Return not found yet!',
                                ])
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            @if ($transactions->hasPages())
                <div class="pt-3">
                    {{ paginateLinks($transactions) }}
                </div>
            @endif
        </div>
    </div>
@endsection


@push('style')
    <style>
        .custom--card .list-group {
            --bs-list-group-border-color: transparent !important;
        }

        @media (max-width: 767px) {
            .main-project .list-group-item:last-child {
                border-bottom: 1px solid hsl(var(--white)/0.1) !important;
            }
        }
    </style>
@endpush
