@extends('Template::layouts.master')
@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <form>
                    <div class="mb-3 d-flex justify-content-end w-50">
                        <div class="input-group">
                            <input class="form-control form--control" name="search" type="search"
                                value="{{ request()->search }}" placeholder="@lang('Search by transactions')">
                            <button class="input-group-text bg--base">
                                <i class="las la-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        {{ __($pageTitle) }}
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Gateway') <span class="text--base">|</span> @lang('Transaction') </th>
                                <th class="text-center">@lang('Initiated')</th>
                                <th class="text-center">@lang('Amount')</th>
                                <th class="text-center">@lang('Conversion')</th>
                                <th class="text-center">@lang('Status')</th>
                                <th>@lang('Details')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($deposits as $deposit)
                                <tr>
                                    <td>
                                        <span class="fw-bold">
                                            <span class="text--base">
                                                @if ($deposit->method_code < 5000)
                                                    {{ __($deposit?->gateway?->name) }}
                                                @else
                                                    @lang('Google Pay')
                                                @endif
                                            </span>
                                        </span>
                                        <br>
                                        <small> {{ $deposit->trx }} </small>
                                    </td>

                                    <td class="text-center">
                                        {{ showDateTime($deposit->created_at) }}<br>{{ diffForHumans($deposit->created_at) }}
                                    </td>
                                    <td class="text-center">
                                        {{ showAmount($deposit->amount) }} + <span class="text--danger"
                                            data-bs-toggle="tooltip"
                                            title="@lang('Processing Charge')">{{ showAmount($deposit->charge) }} </span>
                                        <br>
                                        <strong data-bs-toggle="tooltip" title="@lang('Amount with charge')">
                                            {{ showAmount($deposit->amount + $deposit->charge) }}
                                        </strong>
                                    </td>
                                    <td class="text-center">
                                        {{ showAmount(1) }} = {{ showAmount($deposit->rate, currencyFormat: false) }}
                                        {{ __($deposit->method_currency) }}
                                        <br>
                                        <strong>{{ showAmount($deposit->final_amount, currencyFormat: false) }}
                                            {{ __($deposit->method_currency) }}</strong>
                                    </td>
                                    <td class="text-center">
                                        @php echo $deposit->statusBadge @endphp
                                    </td>
                                    @php
                                        $details = [];
                                        if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                            foreach (isset($deposit->detail) ? $deposit->detail : [] as $key => $info) {
                                                $details[] = $info;
                                                if ($info->type == 'file') {
                                                    $details[$key]->value = route(
                                                        'user.download.attachment',
                                                        encrypt(getFilePath('verify') . '/' . $info->value),
                                                    );
                                                }
                                            }
                                        }
                                    @endphp

                                    <td>
                                        @if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000)
                                            <a class="btn btn--base btn--sm detailBtn"
                                                data-info="{{ json_encode($details) }}" href="javascript:void(0)"
                                                @if ($deposit->status == Status::PAYMENT_REJECT) data-admin_feedback="{{ $deposit->admin_feedback }}" @endif>
                                                <i class="las la-desktop"></i>
                                            </a>
                                        @else
                                            <button class="btn btn--primary btn--sm" data-bs-toggle="tooltip" type="button"
                                                title="@lang('Automatically processed')">
                                                <i class="las la-check"></i>
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-center" colspan="100%">
                                        @include('Template::partials.empty', [
                                            'message' => 'Deposit not found!',
                                        ])
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    @if ($deposits->hasPages())
                        <div class="pt-3">
                            {{ paginateLinks($deposits) }}
                        </div>
                    @endif

                </div>
            </div>
        </div>

        {{-- APPROVE MODAL --}}
        <div class="modal custom--modal fade" id="detailModal" role="dialog" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('Details')</h5>
                        <span class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <ul class="list-group list-group-flush userData mb-2">
                        </ul>
                        <div class="feedback"></div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--danger btn--sm" data-bs-dismiss="modal"
                            type="button">@lang('Close')</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        } else {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span"><a href="${element.value}"><i class="fa-regular fa-file"></i> @lang('Attachment')</a></span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong>@lang('Admin Feedback')</strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);


                modal.modal('show');
            });



        })(jQuery);
    </script>
@endpush
