@extends('Template::layouts.master')
@section('content')
    <div class="container">
        <div class="notice"></div>
        <div class="row  align-items-start gy-4">
            <div class="col-md-12">
                @php
                    $kyc = getContent('kyc.content', true);
                @endphp

                @if ($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason)
                    <div class="alert alert--danger mb-4">
                        <div class="alert__icon">
                            <i class="las la-times"></i>
                        </div>
                        <div class="alert__content">
                            <div class="d-flex justify-content-between">
                                <h5 class="alert__title">@lang('KYC Documents Rejected') </h5>
                                <button class="btn btn-outline--base btn--sm" data-bs-toggle="modal"
                                    data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                            </div>
                            <p class="alert__text">{{ __($kyc?->data_values?->reject) }} <a class="alert__link"
                                    href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a></p>
                        </div>
                    </div>
                @elseif($user->kv == Status::KYC_UNVERIFIED)
                    <div class="alert alert--base mb-4">
                        <div class="alert__icon">
                            <i class="las la-info-circle"></i>
                        </div>
                        <div class="alert__content">
                            <h5 class="alert__title">@lang('KYC Verification required')</h5>
                            <p class="alert__text">{{ __($kyc?->data_values?->required) }} <a class="alert__link"
                                    href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                        </div>
                    </div>
                @elseif($user->kv == Status::KYC_PENDING)
                    <div class="alert alert--warning mb-4">
                        <div class="alert__icon">
                            <i class="fas fa-spinner"></i>
                        </div>
                        <div class="alert__content">
                            <h5 class="alert__title">@lang('KYC Verification pending')</h5>
                            <p class="alert__text">{{ __($kyc?->data_values?->pending) }} <a class="alert__link"
                                    href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                        </div>
                    </div>
                @endif

            </div>
        </div>

        <div class="row gy-4 section-padding">
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="las la-money-bill-wave"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Balance')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($user->balance, currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="icon-Mask-group"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Total Invest')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['total_invest'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="icon-tree"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Total Invested Tree')</p>
                        <h5 class="widget-card__count">{{ formatNumber($widget['total_invest_qty'], 0) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="icon-profit"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Total Profit')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['interests'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="las la-money-bill-wave-alt"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Total Deposit')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['total_deposit'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="icon-withdraw"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Total Withdraw')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['total_withdraw'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="icon-tree-2"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Live Projects')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['running_invests'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="fa-solid fa-users-viewfinder"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Referral Earning')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['referral_earings'], currencyFormat: false) }}</h5>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xxl-4">
                <div class="widget-card ">
                    <div class="widget-card__icon">
                        <i class="las la-funnel-dollar"></i>
                    </div>
                    <div class="widget-card__content">
                        <p class="widget-card__title">@lang('Completed Investment')</p>
                        <h5 class="widget-card__count">
                            {{ gs('cur_sym') . showAmount($widget['completed_invests'], currencyFormat: false) }}
                        </h5>
                    </div>
                </div>
            </div>
        </div>
        <div class="row gy-4 align-items-start">
            <div class="col-lg-8 col-xl-12 col-xxl-8">
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        @lang('Latest Profit')
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>

                    @if (!blank($transactions))
                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('Project')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Date')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($transactions as $profit)
                                    <tr>
                                        <td>{{ strLimit($profit->invest->project->name, 36) }}</td>
                                        <td>{{ showAmount($profit->amount) }}</td>
                                        <td>{{ showDateTime($profit->created_at, 'M d Y @g:i:a') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        @include('Template::partials.empty', ['message' => 'No return dispatched yet!'])
                    @endif
                </div>
            </div>
            <div class="col-lg-4 col-xl-12 col-xxl-4">
                <div class="blog-sidebar-wrapper">
                    <div class="blog-sidebar">
                        <h6 class="blog-sidebar__title">@lang('Successful Projects')</h6>
                        <div class="blog-sidebar__content">
                            @forelse ($projects as $item)
                                <div class="latest-blog style-two">
                                    <div class="latest-blog__thumb">
                                        <a href="{{ route('project.explore', [$item->slug, true]) }}">
                                            <img class="fit-image"
                                                src="{{ getImage(getFilePath('project') . '/thumb_' . @$item->image, getFileSize('project', thumb: true)) }}"
                                                alt="project">
                                        </a>
                                    </div>
                                    <div class="latest-blog__content">
                                        <h6 class="latest-blog__title"><a
                                                href="{{ route('project.explore', [$item->slug, true]) }}">{{ __(strLimit($item->name, 80)) }}</a>
                                        </h6>
                                        <div class="product-card-auth">
                                            <div class="product-card-auth__right">
                                                <small class="rating-wrapper">
                                                    <ul class="rating-list">
                                                        <li class="rating-list__item">@lang('Per Price'):</li>
                                                        <li class="rating-list__item">
                                                            {{ showAmount($item->investment / $item->total_quantity) }}
                                                        </li>
                                                    </ul>
                                                </small>
                                                <p class="latest-blog__profit" data-bs-toggle="tooltip"
                                                    title="@lang('Return On Investment - Profit)')">@lang('ROI')
                                                    @if ($item->interest_type == Status::PERCENTAGE)
                                                        ({{ showAmount($item->minimum_interest, currencyFormat: false) }} -
                                                        {{ showAmount($item->maximum_interest, currencyFormat: false) }})
                                                        %
                                                    @else
                                                        ({{ showAmount($item->fixed_interest) }})
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                @include('Template::partials.empty', [
                                    'message' => 'Successfully project not found!',
                                ])
                            @endforelse

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    @if ($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason)
        <div class="modal custom--modal fade" id="kycRejectionReason" aria-labelledby="exampleModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="exampleModalLabel">@lang('KYC Document Rejection Reason')</h1>
                        <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>{{ $user->kyc_rejection_reason }}</p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--danger btn--sm" data-bs-dismiss="modal"
                            type="button">@lang('Close')</button>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
