@extends('Template::layouts.frontend')
@section('content')
    <div class="py-120 account-section">
        <div class="container">
            <div class="row gy-4 justify-content-between align-items-center">
                <div class="col-lg-6 d-none d-lg-block">
                    <div class="account-thumb">
                        <img src="{{ asset(activeTemplate(true) . 'images/tree.png') }}"
                            data-gif="{{ asset(activeTemplate(true) . 'images/tree.gif') }}" alt="tree" class="lazy-gif">
                    </div>
                </div>

                <div class="col-lg-6 col-xl-5">
                    <form class="account-form verify-gcaptcha" method="POST" action="{{ route('user.login') }}">
                        @csrf

                        <a class="account-form__logo" href="index.html">
                            <img class="fit-image" src="{{ siteLogo() }}" alt="logo">
                        </a>

                        @include('Template::partials.social_login')

                        <div class="form-group">
                            <label for="username" class="form--label">@lang('Email Or Username')</label>
                            <input class="form--control" id="username" name="username" type="text"
                                value="{{ old('username') }}" autocomplete="off">
                        </div>

                        <div class="form-group">
                            <div class="d-flex flex-wrap justify-content-between mb-2">
                                <label class="form-label mb-0" for="password">@lang('Password')</label>
                                <a class="forgot-pass text--base" href="{{ route('user.password.request') }}">
                                    @lang('Forgot your password?')
                                </a>
                            </div>
                            <div class="position-relative">
                                <input class="form--control" id="password" name="password" type="password"
                                    autocomplete="off">
                                <span class="password-show-hide fas fa-eye-slash toggle-password" id="your-password"></span>
                            </div>
                        </div>

                        <x-captcha />

                        <div class="form--check form-group">
                            <input class="form-check-input" id="remember" name="remember" type="checkbox"
                                {{ old('remember') ? 'checked' : '' }}>
                            <label class="form-check-label" for="remember">
                                @lang('Remember me')
                            </label>
                        </div>

                        <div class="form-group">
                            <button class="btn btn--base w-100" id="recaptcha">@lang('Sign In')</button>
                        </div>

                        <div class="text-center">
                            <p class="text-white">@lang("Don't have an account?") <a class="text--base"
                                    href="{{ route('user.register') }}">@lang('Sign up')</a></p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
