@extends('Template::layouts.frontend')
@section('content')
    <section class="py-120 account-section">
        <div class="container">
            <div class="d-flex justify-content-center">
                <div class="verification-code-wrapper account-form">
                    <div class="verification-area">
                        <form class="submit-form " action="{{ route('user.verify.email') }}" method="POST">
                            @csrf
                            <p class="verification-text">@lang('A 6 digit verification code sent to your email address'):
                                {{ showEmailAddress(auth()->user()->email) }}</small>

                                @include('Template::partials.verification_code')

                            <div class="mb-3">
                                <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                            </div>

                            <div class="mb-3">
                                <p>
                                    @lang('If you don\'t get code'), <span class="countdown-wrapper">@lang('try again after') <span
                                            class="fw-bold text--base" id="countdown">--</span> @lang('seconds')</span> <a
                                        class="try-again-link d-none" href="{{ route('user.send.verify.code', 'email') }}">
                                        @lang('Try again')</a>
                                </p>
                                <a class="text--base" href="{{ route('user.logout') }}">@lang('Logout')</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('script')
    <script>
        var distance = Number("{{ isset($user->ver_code_send_at) ? $user->ver_code_send_at->addMinutes(2)->timestamp - time() : '' }}");
        var x = setInterval(function() {
            distance--;
            document.getElementById("countdown").innerHTML = distance;
            if (distance <= 0) {
                clearInterval(x);
                document.querySelector('.countdown-wrapper').classList.add('d-none');
                document.querySelector('.try-again-link').classList.remove('d-none');
            }
        }, 1000);
    </script>
@endpush


@push('style')
    <style>
        .verification-text {
            font-size: 0.975rem;
            color: #fff;
        }
    </style>
@endpush
