@extends('Template::layouts.frontend')

@section('content')
    <section class="pt-120 pb-60">
        <div class="container">
            <div class="row g-3 g-sm-4 justify-content-center">
                @include('Template::partials.story', [
                    'stories' => $stories,
                    'columns' => 'col-xsm-6 col-sm-6 col-lg-4',
                ])
            </div>
            @if ($stories->hasPages())
                <nav class="pt-60">
                    {{ paginateLinks($stories) }}
                </nav>
            @endif
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif
@endsection
