@extends('Template::layouts.frontend')
@section('content')
    <section class="py-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="success-project-card">
                        <div class="success-project-card__thumb">
                            <img src="{{ frontendImage('success_story', @$story->data_values->image, '875x700') }}"
                                alt="thumb">
                        </div>
                        <div class="success-project-card__bottom">
                            <div class="success-project-card__left">
                                <h4 class="success-project-card__title"> {{ __(@$story->data_values->title) }}</h4>
                            </div>
                            <div class="success-project-card-info">
                                <div class="success-project-card-info__content">
                                    <h6 class="success-project-card-info__title"> <i class="las la-calendar"></i>
                                        @lang('Posted at')</h6>
                                    <p class="success-project-card-info__text">
                                        {{ showDateTime($story->created_at, 'd, M Y') }}</p>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="comment-item-block">
                        <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                    </div>

                    <section class="pt-5 milestoneSection">
                        @php echo @$story->data_values->description @endphp
                        <div class="mt-4">
                            <h6 class="post__share__title">@lang('Share now')</h6>
                            <ul class="post__share">
                                <li data-bs-toggle="tooltip" title="@lang('Facebook')">
                                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}"
                                        target="_blank">
                                        <i class="lab la-facebook-f"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('X')">
                                    <a href="https://twitter.com/share?url={{ url()->current() }}" target="_blank">
                                        <i class="fa-brands fa-x-twitter"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('LinkedIn')">
                                    <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ url()->current() }}"
                                        target="_blank">
                                        <i class="lab la-linkedin-in"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('Reddit')">
                                    <a href="http://www.reddit.com/submit?url={{ url()->current() }}" target="_blank">
                                        <i class="lab la-reddit"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('Pinterest')">
                                    <a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(frontendImage('success_story', @$story->data_values->image, '875x700')) }}&description={{ urlencode(@$story->data_values->description) }}"
                                        target="_blank">
                                        <i class="fab fa-pinterest"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('WhatsApp')">
                                    <a href="https://wa.me/?text={{ urlencode(url()->current()) }}" target="_blank">
                                        <i class="fab fa-whatsapp"></i>
                                    </a>
                                </li>
                                <li data-bs-toggle="tooltip" title="@lang('Telegram')">
                                    <a href="https://t.me/share/url?url={{ urlencode(url()->current()) }}&text={{ urlencode(@$story->data_values->title) }}"
                                        target="_blank">
                                        <i class="fab fa-telegram"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </section>
                </div>
                <div class="col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title">@lang('Recently Sucess Projects') </h5>
                            <div class="blog-sidebar__content">
                                @forelse ($recentStories as $story)
                                    <div class="latest-blog">
                                        <div class="latest-blog__thumb">
                                            <a href="{{ route('milestones.details', $story->slug) }}"><img
                                                    class="fit-image"
                                                    src="{{ frontendImage('success_story', 'thumb_' . @$story->data_values->image, '430x275') }}"
                                                    alt=""></a>
                                        </div>
                                        <div class="latest-blog__content">
                                            <h6 class="latest-blog__title"><a
                                                    href="{{ route('milestones.details', $story->slug) }}">{{ __(strLimit(@$story->data_values->title, 80)) }}</a>
                                            </h6>
                                            <p class="product-card-auth__name">
                                                <i class="las la-calendar"></i> @lang('Posted at')
                                                <span class="verify d-block">
                                                    <div class="path2"> {{ showDateTime($story->created_at, 'd, M Y') }}
                                                    </div>
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                @empty
                                    @include('Template::partials.empty', [
                                        'message' => 'Success story not found!',
                                    ])
                                @endforelse
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
