@php
    $content = getContent('why_choose.content', true)->data_values;
    $whyChooseElement = getContent('why_choose.element', false, 4);
@endphp

<section class="whychoose py-60">
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <span class="icon">
                    <i class="icon-plant-tree-1"></i>
                </span>
                {{ __(@$content->title) }}
                <span class="icon">
                    <i class="icon-plant-tree-2"></i>
                </span>
            </div>
            <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
            <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
        </div>

        <div class="row gy-4 gy-sm-5 align-items-center justify-content-center my-xl-5">
            <div class="col-md-4 col-lg-3">
                <div class="whychoose-wrapper">
                    @foreach ($whyChooseElement as $choose)
                        @if ($loop->odd)
                            <div class="whychoose-item">
                                <div class="whychoose-item__top">
                                    <div class="whychoose-item__icon">
                                        @php echo $choose->data_values->icon; @endphp
                                    </div>
                                    <h6 class="whychoose-item__title">{{ __(@$choose->data_values->title) }}</h6>
                                </div>
                                <p class="whychoose-item__desc">{{ __(@$choose->data_values->content) }}</p>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
                <div class="whychoose-center">
                    <img src="{{ frontendImage('why_choose', @$content->image, '190x245') }}" alt="">
                </div>
            </div>
            <div class="col-md-4 col-lg-3">
                <div class="whychoose-wrapper">
                    @foreach ($whyChooseElement as $choose)
                        @if ($loop->even)
                            <div class="whychoose-item right-style">
                                <div class="whychoose-item__top">
                                    <div class="whychoose-item__icon">
                                        @php echo @$choose->data_values->icon; @endphp
                                    </div>
                                    <h6 class="whychoose-item__title">{{ __(@$choose->data_values->title) }}</h6>
                                </div>
                                <p class="whychoose-item__desc">{{ __(@$choose->data_values->content) }}</p>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
