@php
    $latestDeposit = \App\Models\Deposit::with('user', 'gateway')->successful()->latest()->limit(10)->get();
    $fakeDeposit = \App\Models\Frontend::where('data_keys', 'latest_profit.element')->limit(10)->get();
    $deposits = $latestDeposit->merge($fakeDeposit);
    $deposits = $deposits->sortByDesc('created_at')->take(10);

    $latestWithdraw = \App\Models\Withdrawal::with('user', 'method')->approved()->latest()->limit(10)->get();
    $fakeWithdraw = \App\Models\Frontend::where('data_keys', 'latest_withdraw.element')->limit(10)->get();
    $withdrawals = $latestWithdraw->merge($fakeWithdraw);
    $withdrawals = $withdrawals->sortByDesc('created_at')->take(10);

    $content = getContent('transaction.content', true)->data_values;
    $profitContent = getContent('latest_profit.content', true)->data_values;
    $withdrawContent = getContent('latest_withdraw.content', true)->data_values;
@endphp

<section class="latest-profit py-60">
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <span class="icon">
                    <i class="icon-plant-tree-1"></i>
                </span>
                {{ __($content->title) }}
                <span class="icon">
                    <i class="icon-plant-tree-2"></i>
                </span>
            </div>
            <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
            <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
        </div>
        <div class="row gy-4">
            <div class="col-lg-6">
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        {{ __(@$profitContent->title) }}
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Getaway')</th>
                                <th>@lang('Date')</th>
                                <th>@lang('Status')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($deposits as $data)
                                <tr>
                                    @if (@$data->data_values)
                                        <td>{{ __(@$data->data_values->username) }}</td>
                                        <td>{{ showAmount(@$data->data_values->amount) }}</td>
                                        <td>{{ __(@$data->data_values->gateway) }}</td>
                                        <td>{{ @$data->data_values->date }}</td>
                                        <td>
                                            @if (@$data->data_values->profit_status == 'pending')
                                                <span class="badge badge--warning"> @lang('Pending') </span>
                                            @elseif(@$data->data_values->profit_status == 'initiate')
                                                <span class="badge badge--info"> @lang('Initiated') </span>
                                            @elseif(@$data->data_values->profit_status == 'successful')
                                                <span class="badge badge--success"> @lang('Succeed') </span>
                                            @elseif(@$data->data_values->profit_status == 'approved')
                                                <span class="badge badge--success"> @lang('Approved') </span>
                                            @else
                                                <span class="badge badge--danger"> @lang('Rejected') </span>
                                            @endif
                                        </td>
                                    @else
                                        <td>{{ __(@$data->user->fullname) }}</td>
                                        <td>{{ showAmount($data->amount) }}</td>
                                        <td>{{ __(@$data->gateway->name) }}</td>
                                        <td>{{ showDateTime($data->created_at, 'Y-m-d') }}</td>
                                        <td>@php echo $data->statusBadge @endphp</td>
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
            <div class="col-lg-6">
                <div class="table-wrapper table--lg">
                    <h5 class="table-wrapper__title">
                        {{ __(@$withdrawContent->title) }}
                        <span class="title-border">
                            <span class="box"></span>
                        </span>
                    </h5>
                    <table class="table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Getaway')</th>
                                <th>@lang('Date')</th>
                                <th>@lang('Status')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($withdrawals as $data)
                                <tr>
                                    @if (@$data->data_values)
                                        <td>{{ __(@$data->data_values->username) }}</td>
                                        <td>{{ showAmount(@$data->data_values->amount) }}</td>
                                        <td>{{ __(@$data->data_values->gateway) }}</td>
                                        <td>{{ @$data->data_values->date }}</td>
                                        <td>
                                            @if (@$data->data_values->withdraw_status == 'pending')
                                                <span class="badge badge--warning"> @lang('Pending') </span>
                                            @elseif(@$data->data_values->withdraw_status == 'initiate')
                                                <span class="badge badge--info"> @lang('Initiated') </span>
                                            @elseif(@$data->data_values->withdraw_status == 'successful')
                                                <span class="badge badge--success"> @lang('Approved') </span>
                                            @else
                                                <span class="badge badge--danger"> @lang('Rejected') </span>
                                            @endif
                                        </td>
                                    @else
                                        <td>{{ __(@$data->user->fullname) }}</td>
                                        <td>{{ showAmount($data->amount) }}</td>
                                        <td>{{ __(@$data->method->name) }}</td>
                                        <td>{{ showDateTime($data->created_at, 'Y-m-d') }}</td>
                                        <td> @php echo $data->statusBadge @endphp</td>
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</section>
