@php
    $content = getContent('top_investor.content', true)->data_values;
    $topInvestor = \App\Models\Invest::with('user')
        ->selectRaw('SUM(amount) as totalAmount, user_id')
        ->orderBy('totalAmount', 'desc')
        ->groupBy('user_id')
        ->limit(20)
        ->get();
@endphp
@if (!blank($topInvestor))
    <section class="investor-section py-60">
        <div class="container">
            <div class="section-heading-wrapper mb-60">
                <div class="section-heading style-left mb-0">
                    <div class="section-heading__name">
                        <span class="icon">
                            <i class="icon-plant-tree-1"></i>
                        </span>
                        {{ __(@$content->title) }}
                        <span class="icon">
                            <i class="icon-plant-tree-2"></i>
                        </span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
                </div>
                <div class="investor-slider-arrow"></div>
            </div>

            <div class="investor-slider">
                @foreach ($topInvestor as $k => $data)
                    <div class="investor-card">
                        <div class="investor-card__content">
                            <p class="title">@lang('Investment')</p>
                            <p class="amount">{{ showAmount(@$data->totalAmount) }}</p>
                            <h6 class="investor-card__name">
                                {{ @json_decode(json_encode(@$data->user->username)) }}
                            </h6>
                        </div>
                        <span class="investor-item__number">{{ ordinal($loop->iteration) }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endif

@if (!app()->offsetExists('slick_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/slick.min.js') }}"></script>
    @endpush

    @php app()->offsetSet('slick_script',true) @endphp
@endif


@push('script')
    <script>
        (function($) {
            "use strict";

            $(".investor-slider").slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: false,
                pauseOnHover: true,
                arrows: true,
                prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
                appendArrows: $(".investor-slider-arrow"),
                responsive: [{
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 3,
                        },
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            arrows: false,
                        },
                    },
                    {
                        breakpoint: 425,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                        },
                    },
                ],
            });

        })(jQuery);
    </script>
@endpush
