@php
    $content = getContent('testimonial.content', true)->data_values;
    $testimonialElement = getContent('testimonial.element', false, null, true);
@endphp
<section class="testimonials py-60">
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <span class="icon">
                    <i class="icon-plant-tree-1"></i>
                </span>
                {{ __(@$content->title) }}
                <span class="icon">
                    <i class="icon-plant-tree-2"></i>
                </span>
            </div>
            <h2 class="section-heading__title"> {{ __(@$content->heading) }}</h2>
            <p class="section-heading__desc"> {{ __(@$content->subheading) }}</p>
        </div>
        <div class="testimonial-slider">
            @foreach ($testimonialElement as $item)
                <div class="testimonial-item">
                    <div class="testimonial-item__icon">
                        <i class="icon-Group-1000003159"></i>
                    </div>
                    <div class="testimonial-item__info">
                        <div class="testimonial-item__thumb">
                            <img class="fit-image"
                                src="{{ frontendImage('testimonial', @$item->data_values->image, '100x100') }}"
                                alt="">
                        </div>
                        <div class="testimonial-item__details">
                            <p class="testimonial-item__name">{{ __(@$item->data_values->name) }}</p>
                            <ul class="rating-list">
                                @php echo rating(@$item->data_values->rating); @endphp
                            </ul>
                        </div>
                    </div>
                    <p class="testimonial-item__desc">{{ __(@$item->data_values->quote) }}</p>
                </div>
            @endforeach
        </div>
    </div>
</section>

@if (!app()->offsetExists('slick_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/slick.min.js') }}"></script>
    @endpush

    @php app()->offsetSet('slick_script',true) @endphp
@endif

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".testimonial-slider").slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                autoplay: false,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: true,
                pauseOnHover: true,
                arrows: true,
                prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            dots: true,
                        },
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                        },
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                        },
                    },
                ],
            });

        })(jQuery);
    </script>
@endpush
