@php
    $content = getContent('success_story.content', true)->data_values;
    $stories = getContent('success_story.element', orderById: true, limit: 6);
@endphp
<section class="success-section py-120 my-60">
    <div class="success-section__shape">
        <img class="fit-image" src="{{ asset(activeTemplate(true) . 'images/shape/success-shape.png') }}" alt="imgae">
    </div>
    <div class="container">
        <div class="section-heading-wrapper mb-60">
            <div class="section-heading style-left mb-0">
                <div class="section-heading__name">
                    <span class="icon">
                        <i class="icon-plant-tree-1"></i>
                    </span>
                    {{ __(@$content->title) }}
                    <span class="icon">
                        <i class="icon-plant-tree-2"></i>
                    </span>
                </div>
                <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
                <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
            </div>
            <a class="circle-button base" href="{{ __(@$content->button_url) }}">
                <span class="icon"><i class="las la-arrow-right"></i></span>
                <span class="text"> {{ __(@$content->button_name) }}</span>
            </a>
        </div>

        <div class="row g-3 g-sm-4 justify-content-center">
            @include('Template::partials.story', [
                'stories' => $stories,
                'columns' => 'col-xsm-6 col-sm-6 col-lg-4',
            ])
        </div>
    </div>
</section>
