@php
    $content = getContent('subscribe.content', true)->data_values;
@endphp

<section class="newsletter pt-60 pb-120">
    <div class="container custom-container">
        <div class="flex-between newsletter__wrapper">
            <form class="newsletter-form">
                <h3 class="newsletter-form__title">{{ __(@$content->title) }}</h3>
                <div class="newsletter-form__group">
                    <div class="input-group w-100">
                        <input type="email" name="email" class="form-control form--control"
                            placeholder="@lang('Enter your email address')" autocomplete="off">
                        <button class="btn btn--base"><i class="lab la-telegram"></i></button>
                    </div>
                </div>
            </form>
            <div class="newsletter-content">
                <div class="section-heading style-left">
                    <h3 class="section-heading__title">{{ __(@$content->heading) }}</h3>
                    <p class="section-heading__desc">
                        {{ __(@$content->subheading) }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>


@push('script')
    <script>
        'use strict';

        $(function() {
            $('.newsletter-form').on('submit', function(event) {
                event.preventDefault();
                var email = $('.newsletter-form').find('[name="email"]').val();
                if (!email) {
                    notify('error', 'Email field is required');
                } else {
                    $.ajax({
                        headers: {
                            "X-CSRF-TOKEN": "{{ csrf_token() }}",
                        },
                        url: "{{ route('subscribe') }}",
                        method: "POST",
                        data: {
                            email: email
                        },
                        success: function(response) {
                            if (response.success) {
                                notify('success', response.message);
                            } else {
                                notify('error', response.error);
                            }
                            $('.newsletter-form').find('[name="email"]').val('');
                        }
                    });
                }
            });

        })
    </script>
@endpush
