@php
    $content = getContent('popular_project.content', true)->data_values;
    $projects = App\Models\Project::with('timeSetting')
        ->whereHas('timeSetting', function ($time) {
            $time->active();
        })
        ->active()
        ->eligibleToInvest()
        ->where('featured', Status::ENABLE)
        ->get();
@endphp
<section class="latest-product py-60">
    <div class="container">
        <div class="section-heading">
            <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
            <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
        </div>
        <div class="row gy-4 justify-content-center">
            @include('Template::partials.project', [
                'projects' => $projects,
                'columns' => 'col-sm-6 col-lg-4',
            ])
        </div>
    </div>
</section>
