@php
    $content = getContent('invest_step.content', true)->data_values;
    $investStepElement = getContent('invest_step.element', orderById: true);
@endphp

<section class="investstep py-120 my-60">
    <div class="investstep__shape">
        <img src="{{ asset(activeTemplate(true) . 'images/shape/step-shape.png') }}" alt="shape">
    </div>
    <div class="container">
        <div class="row align-content-center justify-content-between gy-5">
            <div class="col-lg-6">
                <div class="investstep-video">
                    <div class="investstep-video__img">
                        <img class="fit-image" src="{{ frontendImage('invest_step', @$content->image, '635x675') }}"
                            alt="">
                    </div>
                    <a href="{{ @$content->video_url }}" class="investstep-video__play" data-rel="lightcase">
                        <span class="video-preview__icon d-flex">
                            <i class="icon-play-button"></i>
                        </span>
                    </a>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <span class="icon">
                            <i class="icon-plant-tree-1"></i>
                        </span>
                        {{ __($content->title) }}
                        <span class="icon">
                            <i class="icon-plant-tree-2"></i>
                        </span>
                    </div>
                    <h2 class="section-heading__title"> {{ __(@$content->heading) }}</h2>
                    <p class="section-heading__desc"> {{ __(@$content->subheading) }}</p>
                </div>
                @foreach ($investStepElement as $step)
                    <div class="investstep-item">
                        <h4 class="investstep-item__count">{{ sprintf('%02d', $loop->iteration) }}</h4>
                        <h5 class="investstep-item__title">{{ __(@$step->data_values->title) }}</h5>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>


@if (!app()->offsetExists('lightcase_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/lightcase.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/lightcase.js') }}"></script>
    @endpush
    @php app()->offsetSet('lightcase_script',true) @endphp
@endif

@push('script')
    <script>
        (function($) {
            "use strict";

            // lightcase
            $("a[data-rel^=lightcase]").lightcase();

        })(jQuery);
    </script>
@endpush
