@php
    @$content = getContent('faq.content', true)->data_values;
    @$faqElement = getContent('faq.element', false, null, true);
@endphp

<section class="faq py-60">
    <div class="faq-circle">
        <div class="faq-circle__icon">
            @php echo $content->circle_icon; @endphp
        </div>
        <p class="faq-circle__text" id="circle-text">
            <span class="opacity-0">{{ __(@$content->circle_content) }} </span>
        </p>
    </div>
    <div class="container">
        <div class="row gy-4 align-items-center">
            <div class="col-lg-6">
                <div class="faq-thumb">
                    <img src="{{ asset(activeTemplate(true) . 'images/faq.png') }}"
                        data-gif="{{ asset(activeTemplate(true) . 'images/faq.gif') }}" alt="tree" class="lazy-gif">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <span class="icon">
                            <i class="icon-plant-tree-1"></i>
                        </span>
                        {{ __($content->title) }}
                        <span class="icon">
                            <i class="icon-plant-tree-2"></i>
                        </span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$content->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$content->subheading) }}</p>
                </div>
                <div class="faq--accordion accordion" id="accordionExample">
                    @foreach (@$faqElement ?? [] as $item)
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button {{ !$loop->first ? 'collapsed' : null }}"
                                    data-bs-toggle="collapse" data-bs-target="#faq_{{ $loop->index }}" type="button"
                                    aria-expanded="{{ !$loop->first ? 'false' : 'true' }}" aria-controls="collapseOne">
                                    {{ __(@$item->data_values->question) }}
                                </button>
                            </h2>
                            <div class="accordion-collapse collapse {{ $loop->first ? 'show' : null }}"
                                id="faq_{{ $loop->index }}" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    {{ __(@$item->data_values->answer) }}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
