@php
    $counterElement = getContent('counter.element', orderById: true);
@endphp
<section class="achievement-section py-60">
    <div class="container">
        <div class="row gy-4">
            @foreach ($counterElement as $key => $counter)
                <div class="col-xsm-6 col-sm-6 col-lg-3">
                    <div class="achievement-item">
                        <div class="achievement-item__icon" id="icon-{{ $key }}">
                            @php echo @$counter->data_values->icon; @endphp
                        </div>
                        <h6 class="achievement-item__title">{{ __(@$counter->data_values->title) }}</h6>
                        <h2 class="achievement-item__count">
                            <span class="odometer" data-odometer-final="{{ __(@$counter->data_values->value) }}">0</span>
                            {{ __(@$counter->data_values->value_suffix) }}
                        </h2>
                    </div>
                </div>
            @endforeach

        </div>
    </div>
</section>

@push('style-lib')
    <link href="{{ asset(activeTemplate(true) . 'css/odometer.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset(activeTemplate(true) . 'js/odometer.min.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/viewport.jquery.js') }}"></script>
@endpush


@push('script')
    <script>
        (function($) {
            "use strict";

            $(".achievement-item").each(function() {
                $(this).isInViewport(function(status) {
                    if (status === "entered") {
                        for (
                            var i = 0; i < document.querySelectorAll(".odometer").length; i++
                        ) {
                            var el = document.querySelectorAll(".odometer")[i];
                            el.innerHTML = el.getAttribute("data-odometer-final");
                        }
                    }
                });
            });

            $(document).ready(function() {
                $('.achievement-item__icon').each(function() {
                    const icon = $(this);

                    $(document).mousemove(function(event) {
                        // Get cursor position
                        const mouseX = event.pageX;
                        const mouseY = event.pageY;

                        // Get the center position of the icon
                        const iconOffset = icon.offset();
                        const iconCenterX = iconOffset.left + icon.width() / 2;
                        const iconCenterY = iconOffset.top + icon.height() / 2;

                        // Calculate the angle between the cursor and the icon center
                        const angle = Math.atan2(mouseY - iconCenterY, mouseX - iconCenterX) * (
                            180 / Math.PI);

                        // Update the rotation angle for the ::after pseudo-element
                        icon.css('--rotation-angle', `${angle+90}deg`);
                    });
                });
            });

        })(jQuery);
    </script>
@endpush
