@php
    $brandElement = getContent('brand.element', false, null, true);
@endphp
<div class="brand-section py-120">
    <div class="brand-section__wrapper">
        <div class="container">
            <div class="brand-slider">
                @foreach ($brandElement as $brand)
                    <div class="brand-item">
                        <img src="{{ frontendImage('brand', @$brand->data_values->image, '140x25') }}" alt="brand">
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

@if (!app()->offsetExists('slick_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/slick.min.js') }}"></script>
    @endpush

    @php app()->offsetSet('slick_script',true) @endphp
@endif


@push('script')
    <script>
        (function($) {
            "use strict";

            $(".brand-slider").slick({
                slidesToShow: 7,
                slidesToScroll: 2,
                autoplay: true,
                pauseOnHover: true,
                speed: 2000,
                dots: false,
                arrows: false,
                infinite: true,
                cssEase: "linear",
                autoplaySpeed: 0,
                verticalSwiping: true,
                swipeToSlide: true,
                swipe: true,

                responsive: [{
                        breakpoint: 1199,
                        settings: {
                            slidesToShow: 6,
                        },
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 4,
                        },
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 3,
                        },
                    },
                    {
                        breakpoint: 400,
                        settings: {
                            slidesToShow: 2,
                        },
                    },
                ],
            });

        })(jQuery);
    </script>
@endpush
