@php
    $content = getContent('blog.content', true)->data_values;
    $blogElement = getContent('blog.element', false, 3);
@endphp
<section class="blog py-60">
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <span class="icon">
                    <i class="icon-plant-tree-1"></i>
                </span>
                {{ __(@$content->title) }}
                <span class="icon">
                    <i class="icon-plant-tree-2"></i>
                </span>
            </div>
            <h2 class="section-heading__title"> {{ __($content?->heading) }}</h2>
            <p class="section-heading__desc">{{ __($content?->subheading) }}</p>
        </div>
        <div class="row gy-4">
            @foreach ($blogElement ?? [] as $blog)
                <div class="col-sm-6 col-lg-4">
                    <div class="blog-item">
                        <div class="blog-item__wrapper">
                            <div class="blog-item__img">
                                <img class="fit-image"
                                     src="{{ frontendImage('blog', 'thumb_' . $blog?->data_values?->image, '380x265') }}"
                                     alt="blog">
                            </div>
                            <div class="blog-item__content">
                                <div class="blog-item-info">
                                    <div class="blog-item-info__img">
                                        <img src="{{ asset(activeTemplate(true) . 'images/shape/calendar.png') }}"
                                             alt="icon">
                                    </div>
                                    <div class="blog-item-info__content">
                                        <p class="blog-item-info__name">@lang('Posted on')</p>
                                        <p class="blog-item-info__time">
                                            {{ showDateTime($blog?->created_at, 'd, M Y') }}
                                        </p>
                                    </div>
                                </div>
                                <h6 class="blog-item__title">
                                    <a
                                       href="{{ route('blog.details', $blog->slug) }}">{{ __(strLimit($blog?->data_values?->title, 80)) }}</a>
                                </h6>
                                <p class="product-card-auth__name">
                                    @lang('By') {{ __($blog?->data_values?->author) }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
