<div class="modal custom--modal invest-modal fade" id="investModal" aria-labelledby="exampleModalLabel2" aria-hidden="true"
    tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form class="invest-form disableSubmission" action="{{ route('user.invest.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel2"><span
                            class="text--base">{{ __($project->name) }}</span></h1>
                    <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <input name="project_id" type="hidden" value="{{ $project->id }}" required>
                    <input name="quantity" type="hidden" value="{{ old('quantity') }}" required>
                    <input type="hidden" name="method" id="paymentMethod" value="gateway">
                    <p class="mt-3 mb-2">
                        <i class="las la-funnel-dollar text--base"></i> @lang('Interest payments will begin on :date (End of Harvest) once the project has been dispatched by the author.', ['date' => showDateTime($project->harvest_date, 'd F, Y')])
                    </p>
                    <ul class="list-group py-3 investData">

                    </ul>

                    <div class="modal-form__footer flex-row gap-3 flex-wrap form-group">
                        <button class="flex-fill btn btn-outline--base active" id="payGatewayButton" type="button">
                            <span class="active-badge"> <i class="las la-check"></i> </span>
                            @lang('Pay via Gateway')
                        </button>
                        <button class="flex-fill btn btn-outline--base" id="payBalanceButton" type="button">
                            <span class="active-badge"> <i class="las la-check"></i> </span>
                            @lang('Pay via Balance')
                        </button>
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn--base" type="sumbit">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('script')
    <script>
        "use strict";
        (function($) {

            $('.investBtn').on('click', function() {
                let quantity = parseFloat($('[name=quantity]').val());
                let amount = $('[name=amount]').val();
                let curText = `{{ gs('cur_text') }}`;
                let minQty = parseFloat(`{{ $project->minimum_quantity }}`);
                let maxQty = parseFloat(`{{ $project->maximum_quantity }}`);

                // Check if the quantity is within the valid range
                if (quantity >= minQty && quantity <= maxQty) {
                    var modal = $('#investModal');
                    modal.find('[name=quantity]').val(quantity);

                    var html = `
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span>@lang('Quantity')</span>
                        <span>${quantity}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span>@lang('Amount')</span>
                        <span>${amount} ${curText}</span>
                    </li>`;

                    modal.find('.investData').html(html);
                    modal.modal('show');
                } else {
                    notify('error', 'Quantity must be between ' + minQty + ' and ' + maxQty, 'error');
                }
            });




            $('#payGatewayButton').on("click", function() {
                $(this).parent().find("button").removeClass('active');
                $(this).addClass('active');
                $('#paymentMethod').val('gateway');
            });

            $('#payBalanceButton').on("click", function() {
                $(this).parent().find("button").removeClass('active');
                $(this).addClass('active');
                $('#paymentMethod').val('balance');
            });

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .invest-modal .form-check-input:focus {
            border-color: hsl(var(--base));
            box-shadow: none;
        }

        .invest-modal .form-check-input:checked {
            background-color: hsl(var(--base));
            border: 1px solid hsl(var(--base));
        }

        .invest-modal .form-check-input {
            border: 1px solid hsl(var(--base));
        }

        .invest-modal .modal-form__footer button.active {
            border-color: hsl(var(--base));
            position: relative;
        }

        .invest-modal .modal-form__footer button .active-badge {
            display: none;
        }

        .invest-modal .modal-form__footer button.active .active-badge {
            right: 0px;
            top: -1px;
            position: absolute;
            color: #ffffff;
            background: hsl(var(--base));
            text-align: right;
            width: 50px;
            height: 40px;
            padding-right: 4px;
            clip-path: polygon(100% 0, 0 1%, 100% 100%);
            display: block;
            border-top-right-radius: 5px;
        }

        .invest-modal .btn-outline--base:hover,
        .invest-modal .btn-outline--base:focus .invest-modal .btn-outline--base:focus-visible {
            background-color: hsl(var(--base) / 0.05) !important;
            color: hsl(var(--base)) !important;
        }

        .invest-modal .selected-gateway {
            border-color: hsl(var(--base)/0.32) !important;
        }

        .preview-details {
            font-size: 0.875rem;
        }
    </style>
@endpush
