@extends('Template::layouts.frontend')

@section('content')
    <section class="projects-section py-120">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                @include('Template::partials.project', [
                    'projects' => $projects,
                    'columns' => 'col-sm-6 col-lg-4 col-xl-3',
                ])
            </div>

            <nav class="pt-60">
                @if ($projects->hasPages())
                    {{ paginateLinks($projects) }}
                @endif
            </nav>
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif
@endsection

@push('style')
    <style>
        /* new css in product */

        @media (min-width: 1200px) {

            .product-card-info {
                margin-bottom: 12px;
            }

            .product-card-info__img {
                width: 24px;
            }

            .product-card-info__time,
            .product-card-info__name,
            .product-card-profit__title {
                font-size: 12px;
            }

            .product-card__title {
                margin-bottom: 16px;
                font-size: 18px;
            }

            .product-card-profit__parcent {
                font-size: 14px;
            }

            .product-card__content {
                margin-top: -42px;
            }
        }
    </style>
@endpush
