@extends('Template::layouts.frontend')

@section('content')
    <section class="py-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="product-card style-two">
                        <div class="product-card__wrapper">
                            <div class="product-card__img">
                                @if (@$project->video_link)
                                    <a class="product-card__play" data-rel="lightcase" href="{{ @$project->video_link }}">
                                        <span class="video-preview__icon d-flex">
                                            <i class="icon-play-button"></i>
                                        </span>
                                    </a>
                                @endif
                                <img src="{{ getImage(getFilePath('project') . '/' . $project->image, getFileSize('project')) }}"
                                    alt="project">
                            </div>
                            <div class="product-card__content">
                                <div class="product-card-info">
                                    <div class="product-card-info__img">
                                        <img src="{{ asset(activeTemplate(true) . 'images/shape/icon.png') }}"
                                            alt="icon">
                                    </div>
                                    <div class="product-card-info__content">
                                        <p class="product-card-info__name">@lang('Harvest Time')</p>
                                        <p class="product-card-info__time">{{ convertHarvestTime($project->harvest_time) }}
                                        </p>
                                    </div>
                                </div>

                                <h6 class="product-card__title">
                                    <a href="{{ route('project.explore', $project->slug) }}">{{ __($project->name) }}</a>
                                </h6>

                                <div class="product-card-bottom">
                                    <div class="product-card-profit">
                                        <p class="product-card-profit__title" data-bs-toggle="tooltip"
                                            title="@lang('Return On Investment - Profit')">@lang('ROI')</p>
                                        @if ($project->interest_type == Status::PERCENTAGE)
                                            <h5 class="product-card-profit__parcent">
                                                {{ showAmount($project->minimum_interest, currencyFormat: false) }}% -
                                                {{ showAmount($project->maximum_interest, currencyFormat: false) }}%</h5>
                                        @else
                                            <h5 class="product-card-profit__parcent">
                                                {{ showAmount($project->fixed_interest) }}</h5>
                                        @endif
                                    </div>
                                    <div class="product-card-profit">
                                        <p class="product-card-profit__title"> @lang('Cost Per Unit')</p>
                                        <h5 class="product-card-profit__parcent">
                                            {{ showAmount($project->per_tree_amount) }}</h5>
                                    </div>
                                    <div class="product-card-profit">
                                        <p class="product-card-profit__title"> @lang('Invest End Date')</p>
                                        <h5 class="product-card-profit__parcent">
                                            {{ showDateTime($project->invest_end_date, 'd M, Y') }}</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <section class="details-tab pt-60">
                        <ul class="nav custom--tab">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#overview"
                                    type="button">@lang('Overview')</button>
                            </li>
                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#about"
                                    type="button">@lang('About')</button>
                            </li>
                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#faq"
                                    type="button">@lang("FAQ's")</button>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane show active" id="overview">
                                <h4 class="details-heading  mb-5">@lang('Project Overview')</h4>
                                @php echo $project->overview; @endphp
                            </div>
                            <div class="tab-pane" id="about" role="tabpanel">
                                <h4 class="details-heading  mb-5">@lang('Project About')</h4>
                                @php echo $project->about; @endphp
                            </div>
                            <div class="tab-pane" id="faq">
                                <h4 class="details-heading  mb-5">@lang("Project FAQ's")</h4>
                                <div class="accordion faq--accordion" id="projectFAQ">
                                    @foreach ($project->faqs->question ?? [] as $key => $faq)
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="heading{{ $key + 1 }}">
                                                <button class="accordion-button collapsed" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse{{ $key + 1 }}" type="button"
                                                    aria-expanded="false" aria-controls="collapse{{ $key + 1 }}">
                                                    {{ __($project->faqs->question[$key]) }}
                                                </button>
                                            </h2>
                                            <div class="accordion-collapse collapse" id="collapse{{ $key + 1 }}"
                                                data-bs-parent="#projectFAQ" aria-labelledby="heading{{ $key + 1 }}">
                                                <div class="accordion-body">
                                                    <div class="details-faq-content">
                                                        {{ __($project->faqs->answer[$key]) }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                    </section>

                    <div class="share-content-inner mt-60">
                        <div class="d-block copy-link w-100">
                            <div class="input-group  p-4 pb-0">
                                <input class="copyURL form-control form--control" type="text"
                                    value="{{ url()->current() }}" readonly>
                                <span class="copyBoard input-group-text btn btn--base" id="copyBoard">
                                    <i class="las la-copy"></i> <strong class="copyText">@lang('Copy')</strong>
                                </span>
                            </div>
                        </div>

                        <ul class="post__share">
                            <li data-bs-toggle="tooltip" title="@lang('Facebook')">
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}"
                                    target="_blank">
                                    <i class="lab la-facebook-f"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('X')">
                                <a href="https://twitter.com/share?url={{ url()->current() }}" target="_blank">
                                    <i class="fa-brands fa-x-twitter"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('LinkedIn')">
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ url()->current() }}"
                                    target="_blank">
                                    <i class="lab la-linkedin-in"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Reddit')">
                                <a href="http://www.reddit.com/submit?url={{ url()->current() }}" target="_blank">
                                    <i class="lab la-reddit"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Pinterest')">
                                <a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(getImage(getFilePath('project') . '/' . $project->image, getFileSize('project'))) }}&description={{ urlencode($project->overview) }}"
                                    target="_blank">
                                    <i class="fab fa-pinterest"></i>
                                </a>
                            </li>

                            <li data-bs-toggle="tooltip" title="@lang('WhatsApp')">
                                <a href="https://wa.me/?text={{ urlencode(url()->current()) }}" target="_blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Telegram')">
                                <a href="https://t.me/share/url?url={{ urlencode(url()->current()) }}&text={{ urlencode($project->slug) }}"
                                    target="_blank">
                                    <i class="fab fa-telegram"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <!-- ============================= Project Details Sidebar Start ======================== -->
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title">@lang('Project Info')</h5>
                            <div class="blog-sidebar__content">
                                <div class="projet-details-info">
                                    <ul class="projet-details-info__list">
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Minimum Invest')</span>
                                            <span class="projet-details-info__text">{{ $project->minimum_quantity }}
                                                @lang('Qty')</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Miximum Invest')</span>
                                            <span class="projet-details-info__text">{{ $project->maximum_quantity }}
                                                @lang('Qty')</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Return Interval')</span>
                                            <span
                                                class="projet-details-info__text">{{ __($project->timeSetting->name) }}</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Return for')</span>
                                            <span class="projet-details-info__text">
                                                @if ($project->lifetime == Status::LIFETIME)
                                                    @lang('Life Time')
                                                @else
                                                    {{ $project->repeat_time }} @lang('Times')
                                                @endif
                                            </span>
                                        </li>
                                        @if ($project->lifetime == Status::REPEAT)
                                            <li class="projet-details-info__item">
                                                <span class="projet-details-info__title">@lang('Capital Back')</span>
                                                <span class="projet-details-info__text">
                                                    @if ($project->capital_back == Status::YES)
                                                        @lang('Yes')
                                                    @else
                                                        @lang('No')
                                                    @endif
                                                </span>
                                            </li>
                                        @endif


                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Available Quantity')</span>
                                            <span class="projet-details-info__text">
                                                {{ $project->total_quantity - $project->invests_count }}
                                                @lang('Qty')</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Crops Duration')</span>
                                            <span class="projet-details-info__text">{{ $project->crop_duration }}
                                                @lang('Years')</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Investment Goal')</span>
                                            <span
                                                class="projet-details-info__text">{{ showAmount($project->investment) }}</span>
                                        </li>
                                        <li class="projet-details-info__item">
                                            <span class="projet-details-info__title">@lang('Created at')</span>
                                            <span
                                                class="projet-details-info__text">{{ diffForHumans($project->created_at) }}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        @if ($project->is_dispatch == Status::INTEREST_NOT_DISPATCH)
                            <div class="blog-sidebar">
                                <h5 class="blog-sidebar__title">
                                    <div class="d-flex justify-content-between">
                                        @lang('Quick Invest') <span class="spinner-grow" role="status"></span>
                                    </div>
                                </h5>
                                <div class="blog-sidebar__content">
                                    <form class="invest-form">
                                        <div class="form-group">
                                            <label class="form-label" for="invest-quantity">@lang('Quantity')
                                                <small data-bs-toggle="tooltip"
                                                    title="@lang('Available Unit'): {{ $project->total_quantity - $project->invests_count }} @lang('Qty') @lang('Minimum applicable quantity'): {{ $project->minimum_quantity }} & @lang('Maximum applicable quantity'): {{ $project->maximum_quantity }}">
                                                    <i class="las la-info-circle"></i>
                                                </small>
                                            </label>
                                            <div class="input-group">
                                                <input class="form-control form--control" name="quantity" type="number"
                                                    placeholder="@lang('Enter invest quantity')"
                                                    min="{{ $project->minimum_quantity }}"
                                                    max="{{ $project->maximum_quantity }}" required>
                                                <span class="input-group-text">@lang('Qty')</span>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label" for="invest-amount">@lang('Amount')</label>
                                            <div class="input-group">
                                                <span class="input-group-text">{{ gs('cur_sym') }}</span>
                                                <input class="form-control form--control" id="invest-amount"
                                                    name="amount" type="number" value="{{ old('amount') }}" required
                                                    readonly>
                                                <span class="input-group-text">{{ gs('cur_text') }}</span>
                                            </div>
                                        </div>
                                        <button class="btn btn--base w-100 investBtn disabled" type="button"><i
                                                class="lab la-telegram"></i> @lang('Invest Now')</button>
                                    </form>
                                </div>
                            </div>
                        @endif

                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title"> @lang('Latest Projects') </h5>
                            <div class="blog-sidebar__content">
                                @forelse ($latestProjects as $item)
                                    <div class="latest-blog">
                                        <div class="latest-blog__thumb">
                                            <a href="{{ route('project.explore', $item->slug) }}">
                                                <img class="fit-image"
                                                    src="{{ getImage(getFilePath('project') . '/thumb_' . @$item->image, getFileSize('project', thumb: true)) }}"
                                                    alt="project">
                                            </a>
                                        </div>
                                        <div class="latest-blog__content">
                                            <h6 class="latest-blog__title"><a
                                                    href="{{ route('project.explore', $item->slug) }}">{{ __(strLimit($item->name, 80)) }}</a>
                                            </h6>
                                            <div class="product-card-auth">
                                                <div class="product-card-auth__right">
                                                    <small class="rating-wrapper">
                                                        <ul class="rating-list">
                                                            <li class="rating-list__item">@lang('Per Unit Amount'): </li>
                                                            <li class="rating-list__item">
                                                                {{ showAmount($item->per_tree_amount) }}</li>
                                                        </ul>
                                                    </small>
                                                    <p class="product-card-auth__name text--primary">
                                                        @lang('Harvest Time'):
                                                        <span
                                                            class="verify text--primary">{{ convertHarvestTime($item->harvest_time) }}</span>

                                                    </p>
                                                </div>
                                            </div>
                                            <p class="latest-blog__profit" data-bs-toggle="tooltip"
                                                title="@lang('Return On Investment - Profit)')">@lang('ROI'):
                                                @if ($item->interest_type == Status::PERCENTAGE)
                                                    ({{ showAmount($item->minimum_interest, currencyFormat: false) }} -
                                                    {{ showAmount($item->maximum_interest, currencyFormat: false) }})
                                                    %
                                                @else
                                                    ({{ showAmount($item->fixed_interest) }})
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                @empty
                                    @include('Template::partials.empty', [
                                        'message' => 'Project not found!',
                                    ])
                                @endforelse
                            </div>
                        </div>
                    </div>
                    <!-- ============================= Project Details Sidebar End ======================== -->
                </div>
            </div>
        </div>
    </section>

    @include('Template::project.invest_modal')

@endsection

@if (!app()->offsetExists('lightcase_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/lightcase.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/lightcase.js') }}"></script>
    @endpush
    @php app()->offsetSet('lightcase_script',true) @endphp
@endif

@push('script')
    <script>
        (function($) {
            "use strict"

            // lightcase
            $("a[data-rel^=lightcase]").lightcase();

            $('[name=quantity]').on('input', function() {
                let qty = parseFloat($(this).val());
                manageQty(qty);
            });

            function manageQty(qty) {
                let prePrice = parseFloat(`{{ $project->investment / $project->total_quantity }}`);
                let totalAmount = qty * prePrice;
                let minQty = parseFloat(`{{ $project->minimum_quantity }}`);
                let maxQty = parseFloat(`{{ $project->maximum_quantity }}`);



                $('[name=amount]').val(totalAmount.toFixed(2));

                if (qty >= minQty && qty <= maxQty) {
                    $('.investBtn').removeClass('disabled');
                } else {
                    $('.investBtn').addClass('disabled');
                }
            }

            $('.copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
            });

        })(jQuery);
    </script>
@endpush


@push('style')
    <style>
        .post__share {
            margin-top: 0 !important;
        }
    </style>
@endpush
