@forelse ($projects as $project)
    <div class="{{ $columns }}">
        <div class="product-card">
            <div class="product-card__wrapper">
                <div class="product-card__img">
                    @if (@$project->video_link)
                        <a class="product-card__play" data-rel="lightcase" href="{{ @$project->video_link }}">
                            <span class="video-preview__icon d-flex">
                                <i class="icon-play-button"></i>
                            </span>
                        </a>
                    @endif
                    <img src="{{ getImage(getFilePath('project') . '/thumb_' . @$project->image, getFileSize('project', thumb: true)) }}"
                        alt="project">
                </div>
                <div class="product-card__content">
                    <div class="product-card-info">
                        <div class="product-card-info__img">
                            <img src="{{ asset(activeTemplate(true) . 'images/shape/icon.png') }}" alt="icon">
                        </div>
                        <div class="product-card-info__content">
                            <p class="product-card-info__name">@lang('Harvest Time')</p>
                            <p class="product-card-info__time">{{ convertHarvestTime($project->harvest_time) }}</p>
                        </div>
                    </div>
                    <h6 class="product-card__title">
                        <a href="{{ route('project.explore', $project->slug) }}">{{ __($project->name) }}</a>
                    </h6>
                    <div class="product-card-bottom">
                        <div class="product-card-profit">
                            <p class="product-card-profit__title" data-bs-toggle="tooltip" title="@lang('Return On Investment - Profit')">
                                @lang('ROI')</p>
                            @if ($project->interest_type == Status::PERCENTAGE)
                                <h5 class="product-card-profit__parcent">
                                    {{ showAmount($project->minimum_interest, currencyFormat: false) }}% -
                                    {{ showAmount($project->maximum_interest, currencyFormat: false) }}%</h5>
                            @else
                                <h5 class="product-card-profit__parcent">{{ showAmount($project->fixed_interest) }}</h5>
                            @endif
                        </div>
                        <div class="product-card-profit">
                            <p class="product-card-profit__title">@lang('Cost Per Unit')</p>
                            <h5 class="product-card-profit__parcent"> {{ showAmount($project->per_tree_amount) }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@empty
    @include('Template::partials.empty', ['message' => 'Project not found!'])
@endforelse


@if (!app()->offsetExists('lightcase_script'))
    @push('style-lib')
        <link href="{{ asset(activeTemplate(true) . 'css/lightcase.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset(activeTemplate(true) . 'js/lightcase.js') }}"></script>
    @endpush
    @php app()->offsetSet('lightcase_script',true) @endphp
@endif

@push('script')
    <script>
        (function($) {
            "use strict";

            // lightcase
            $("a[data-rel^=lightcase]").lightcase();

        })(jQuery);
    </script>
@endpush
