@if (gs('multi_language'))
    @php
        $language = App\Models\Language::all();
        $selectLang = $language->where('code', config('app.locale'))->first();
        $currentLang = session('lang') ? $language->where('code', session('lang'))->first() : $language->where('is_default', Status::YES)->first();
    @endphp
    <div class="language dropdown">
        <div class="language__icon">
            <img src="{{ getImage(getFilePath('language') . '/' . $currentLang->image, getFileSize('language')) }}" alt="@lang('image')">
        </div>
        <div class="language__wrapper" data-bs-toggle="dropdown">
            <p class="language__text">{{ __(@$selectLang->name) }}</p>
            <span class="language__arrow"><i class="fas fa-chevron-down"></i></span>
        </div>
        <div class="dropdown-menu">
            <ul class="language-list">
                @foreach ($language as $lang)
                    @if ($lang->id != $currentLang->id)
                        <li class="language-list__item langSel" data-code="{{ $lang->code }}">
                            <div class="language__icon">
                                <img src="{{ getImage(getFilePath('language') . '/' . $lang->image, getFileSize('language')) }}" alt="image">
                            </div>
                            <p class="language_text">{{ $lang->name }}</p>
                        </li>
                    @endif
                @endforeach
            </ul>
        </div>
    </div>

    @push('script')
        <script>
            $('.custom--dropdown > .custom--dropdown__selected').on('click', function() {
                $(this).parent().toggleClass('open');
            });
            $('.custom--dropdown > .dropdown-list > .dropdown-list__item').on('click', function() {
                $('.custom--dropdown > .dropdown-list > .dropdown-list__item').removeClass('selected');
                $(this).addClass('selected').parent().parent().removeClass('open').children(
                    '.custom--dropdown__selected').html($(this).html());
            });
            $(document).on('keyup', function(evt) {
                if ((evt.keyCode || evt.which) === 27) {
                    $('.custom--dropdown').removeClass('open');
                }
            });
            $(document).on('click', function(evt) {
                if ($(evt.target).closest(".custom--dropdown > .custom--dropdown__selected").length === 0) {
                    $('.custom--dropdown').removeClass('open');
                }
            });
        </script>
    @endpush
@endif
