<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-xl">
            <a class="navbar-brand logo m-0" href="{{ route('home') }}">
                <img src="{{ siteLogo() }}" class="logo-light" alt="logo">

                @if (request()->routeIs('home'))
                    <img src="{{ siteLogo('dark') }}" class="logo-dark" alt="logo">
                @else
                    <img src="{{ siteLogo() }}" class="logo-dark" alt="logo">
                @endif

            </a>
            <button class="navbar-toggler header-button" data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasDarkNavbar" type="button" aria-controls="offcanvasDarkNavbar"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="offcanvas border-0  offcanvas-end" id="offcanvasDarkNavbar" tabindex="-1">
                <div class="offcanvas-header">
                    <a class="logo navbar-brand" href="{{ route('home') }}">
                        <img src="{{ siteLogo() }}" alt="logo">
                    </a>
                    <button class="btn-close btn-close-white" data-bs-dismiss="offcanvas" type="button"
                        aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <ul class="navbar-nav w-100 justify-content-xl-end nav-menu align-items-xl-center">
                        <li class="mb-3 d-xl-none">
                            @include('Template::partials.language')
                        </li>
                        <li class="nav-item {{ menuActive('home') }}">
                            <a class="nav-link" href="{{ route('home') }}" aria-current="page">@lang('Home')</a>
                        </li>

                        @if (count($pages) > 1)
                            <li class="nav-item dropdown {{ request()->routeIs('pages') ? 'active' : '' }}">
                                <div class="navDropdown dropdown">
                                    <div class="navDropdown__wrapper" data-bs-toggle="dropdown">
                                        <p class="nav-link dropdown-toggle" id="pagesDropdown" role="button"
                                            aria-haspopup="true" aria-expanded="false">
                                            {{ __('Pages') }}
                                            <span class="navDropdown__arrow"><i class="fas fa-chevron-down"></i></span>
                                        </p>
                                    </div>
                                    <div class="dropdown-menu" aria-labelledby="pagesDropdown">
                                        <ul class="navDropdown-list">
                                            @foreach ($pages as $k => $data)
                                                <li class="navDropdown-list__item">
                                                    <a class="dropdown-item {{ menuActive('pages', null, @$data->slug) }}"
                                                        href="{{ route('pages', $data->slug) }}">
                                                        {{ __($data->name) }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </li>
                        @else
                            @foreach ($pages as $k => $data)
                                <li class="nav-item {{ menuActive('pages', null, @$data->slug) }}">
                                    <a class="nav-link"
                                        href="{{ route('pages', $data->slug) }}">{{ __($data->name) }}</a>
                                </li>
                            @endforeach
                        @endif

                        <li class="nav-item {{ menuActive(['all.projects', 'project.explore']) }}">
                            <a class="nav-link" href="{{ route('all.projects') }}"> @lang('Projects') </a>
                        </li>
                        <li class="nav-item {{ menuActive(['milestones', 'milestones.details']) }}">
                            <a class="nav-link" href="{{ route('milestones') }}">@lang('Milestones')</a>
                        </li>
                        <li class="nav-item {{ menuActive(['blogs', 'blog.details']) }}">
                            <a class="nav-link" href="{{ route('blogs') }}">@lang('Blogs')</a>
                        </li>
                        <li class="nav-item {{ menuActive('contact') }}">
                            <a class="nav-link" href="{{ route('contact') }}">@lang('Contact')</a>
                        </li>
                        @auth
                            <li class="nav-item mt-4 d-xl-none">
                                <div class="header-right d-xl-none">
                                    <div class="header-button flex-align gap-3">
                                        <a class="w-100 btn btn-outline--base" href="{{ route('user.home') }}"><i
                                                class="las la-tachometer-alt"></i> @lang('Dashboard')</a>
                                    </div>
                                </div>
                            </li>
                        @else
                            <li class="nav-item mt-4 d-xl-none">
                                <div class="header-right d-xl-none">
                                    <div class="header-button flex-align gap-3">
                                        <a class="w-100 btn btn--base"
                                            href="{{ route('user.login') }}">@lang('Sign In')</a>
                                        <a class="w-100 btn btn-outline--base"
                                            href="{{ route('user.register') }}">@lang('Sign Up')</a>
                                    </div>
                                </div>
                            </li>
                        @endauth
                    </ul>
                </div>
            </div>
            <div class="header-right ms-4 d-none d-xl-block">
                <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                    <ul class="login-registration-list flex-wrap align-items-center">
                        <li class="d-none d-xl-block">
                            @include('Template::partials.language')
                        </li>
                        @auth
                            <li class="login-registration-list__item">
                                <a class="btn btn--base" href="{{ route('user.home') }}"><i
                                        class="las la-tachometer-alt"></i> @lang('Dashboard')</a>
                            </li>
                        @else
                            <li class="login-registration-list__item">
                                <a class="btn btn--base" href="{{ route('user.login') }}">
                                    <i class="las la-sign-in-alt"></i>
                                    @lang('Sign In')
                                </a>
                            </li>
                        @endauth
                    </ul>
                </div>
            </div>
        </nav>
    </div>
</header>
