@php
    $contact = getContent('contact_us.content', true)->data_values;
    $socialIcons = getContent('social_icon.element', false, null, true);
    $policyPages = getContent('policy_pages.element', false, null, true);

    $projectCollection = \App\Models\Project::with('timeSetting')
        ->whereHas('timeSetting', function ($time) {
            $time->active();
        })
        ->active()
        ->eligibleToInvest()
        ->inRandomOrder()
        ->take(5)
        ->get();
@endphp

<footer class="footer-area">
    <div class="container">
        <div class="row justify-content-between gy-5">
            <div class="col-xl-3 col-md-6 col-sm-6 col-xsm-6">
                <div class="footer-item">
                    <a class="footer-item__logo" href="{{ route('home') }}">
                        <img src="{{ siteLogo() }}" alt="logo">
                    </a>
                    <p class="footer-item__desc">@php echo @$contact->website_footer;@endphp</p>

                    <ul class="social-list">
                        @foreach ($socialIcons as $social)
                            <li class="social-list__item">
                                <a class="social-list__link mb-2" href="{{ @$social->data_values->url }}"
                                    title="{{ __(@$social->data_values->title) }}">
                                    @php echo @$social->data_values->social_icon @endphp
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-xl-2 col-md-6 col-sm-6 col-xsm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title">
                        <span class="title-border"> <span class="box"></span> </span>
                        @lang('Site Links')
                    </h5>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a class="footer-menu__link"
                                href="{{ route('home') }}">@lang('Home')</a></li>
                        <li class="footer-menu__item"><a class="footer-menu__link"
                                href="{{ route('all.projects') }}">@lang('Projects')</a></li>
                        <li class="footer-menu__item"><a class="footer-menu__link"
                                href="{{ route('blogs') }}">@lang('Blogs')</a></li>
                        <li class="footer-menu__item"><a class="footer-menu__link"
                                href="{{ route('contact') }}">@lang('Contact')</a></li>
                        @auth
                            <li class="footer-menu__item"><a class="footer-menu__link"
                                    href="{{ route('user.home') }}">@lang('Dashboard')</a></li>
                        @else
                            <li class="footer-menu__item"><a class="footer-menu__link"
                                    href="{{ route('user.login') }}">@lang('Sign In')</a></li>
                        @endauth
                    </ul>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-sm-6 col-xsm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title">
                        <span class="title-border"> <span class="box"></span> </span>
                        @lang('Collections')
                    </h5>
                    <ul class="footer-menu">
                        @foreach (@$projectCollection as $project)
                            <li class="footer-menu__item"><a class="footer-menu__link"
                                    href="{{ route('project.explore', $project->slug) }}">{{ strLimit(__($project->name), 18) }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-sm-6 col-xsm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title">
                        <span class="title-border"> <span class="box"></span> </span>
                        @lang('Quick Links')
                    </h5>
                    <ul class="footer-menu">
                        @foreach ($pages as $k => $data)
                            <li class="footer-menu__item"><a class="footer-menu__link"
                                    href="{{ route('pages', $data->slug) }}">{{ __(@$data->name) }}</a></li>
                        @endforeach
                        @foreach ($policyPages as $policy)
                            <li class="footer-menu__item"><a class="footer-menu__link"
                                    href="{{ route('policy.pages', $policy->slug) }}">
                                    {{ __(@$policy->data_values->title) }}</a></li>
                        @endforeach
                        <li class="footer-menu__item"><a class="footer-menu__link"
                                href="{{ route('user.register') }}">@lang('Join With') {{ __(gs('site_name')) }}</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-2 col-md-4 col-sm-6 col-xsm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title">
                        <span class="title-border"> <span class="box"></span> </span>@lang('Get In Touch')
                    </h5>
                    <div class="footer-info">
                        <div class="footer-info__item">
                            <div class="footer-info__icon">
                                <i class="icon-pin"></i>
                            </div>
                            <div class="footer-info__content">
                                <p class="footer-info__title">@lang('Location')</p>
                                <p class="footer-info__desc">{{ __(@$contact->address_location) }}</p>
                            </div>
                        </div>
                        <div class="footer-info__item">
                            <div class="footer-info__icon">
                                <i class="icon-call"></i>
                            </div>
                            <div class="footer-info__content">
                                <p class="footer-info__title">@lang('Phone')</p>
                                <p class="footer-info__desc">
                                    <a href="tel:{{ @$contact->contact_number }}">{{ @$contact->contact_number }}</a>
                                </p>
                            </div>
                        </div>
                        <div class="footer-info__item">
                            <div class="footer-info__icon">
                                <i class="icon-email-2"></i>
                            </div>
                            <div class="footer-info__content">
                                <p class="footer-info__title">@lang('Email')</p>
                                <p class="footer-info__desc">
                                    <a
                                        href="mailto:{{ __(@$contact->email_address) }}">{{ __(@$contact->email_address) }}</a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12 text-center">
                <div class="bottom-footer-text">
                    <p>&copy; {{ date('Y') }} <a class="text--base"
                            href="{{ route('home') }}">{{ __(gs('site_name')) }}</a>. @lang('All Right Reserved')</p>
                </div>
            </div>
        </div>
    </div>
</footer>
