@php
    $content = getContent('banner.content', true);
    $bannerElement = getContent('banner.element', false, 3);
@endphp
<section class="banner-section">
    <div class="banner-section__shape">
        <div class="banner-shape-one">
            <img src="{{ asset(activeTemplate(true) . 'images/shape/hero-shape1.png') }}" alt="image-one">
        </div>
        <div class="banner-shape-two">
            <img src="{{ asset(activeTemplate(true) . 'images/shape/hero-shape2.png') }}" alt="image-three">
        </div>
        <div class="banner-shape-three">
            <img src="{{ asset(activeTemplate(true) . 'images/shape/hero-shape3.png') }}" alt="image-two">
        </div>
    </div>
    <div class="banner-section__colorshape">
        <img src="{{ asset(activeTemplate(true) . 'images/shape/color-shape.png') }}" alt="shape">
    </div>
    <div class="container">
        <div class="row gy-4 align-items-center justify-content-between">
            <div class="col-md-6 col-lg-7 order-md-0 order-1">
                <div class="banner-content">
                    <h1 class="banner-content__title">{{ __(@$content->data_values->heading) }}</h1>

                    <div class="banner-content__button">
                        <a href=" {{ @$content->data_values->button_url }} " class="circle-button custom-circle-button">
                            <span class="icon"><i class="las la-arrow-right"></i></span>
                            <span class="text"> {{ __(@$content->data_values->button_name) }} </span>
                        </a>
                    </div>

                </div>
            </div>
            <div class="col-md-6 col-lg-5 order-md-1 order-0">
                <div class="banner-image">
                    <img src="{{ asset(activeTemplate(true) . 'images/tree.png') }}"
                        data-gif="{{ asset(activeTemplate(true) . 'images/tree.gif') }}" alt="tree" class="lazy-gif">
                </div>
            </div>
            <div class="col-lg-9 ms-auto order-2">
                <div class="banner-wrapper">
                    @foreach ($bannerElement as $banner)
                        <div class="banner-card">
                            <span class="banner-card__icon">
                                @php echo @$banner->data_values->icon;@endphp
                            </span>
                            <h6 class="banner-card__title">{{ __(@$banner->data_values->title) }}</h6>
                            <h2 class="banner-card__count">{{ __(@$banner->data_values->value) }}</h2>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>


@push('script')
    <script>
        (function($) {
            "use strict";

            $(document).ready(function() {
                const button = $('.custom-circle-button');
                const icon = button.find('.icon');

                // Mouse move event
                $(document).mousemove(function(event) {
                    // Get cursor position
                    const mouseX = event.pageX;
                    const mouseY = event.pageY;

                    // Get the center position of the button
                    const buttonOffset = button.offset();
                    const buttonCenterX = buttonOffset.left + button.width() / 2;
                    const buttonCenterY = buttonOffset.top + button.height() / 2;

                    // Calculate the angle between the cursor and the button center
                    const angle = Math.atan2(mouseY - buttonCenterY, mouseX - buttonCenterX) * (180 /
                        Math.PI);

                    icon.css({
                        'transform': `rotate(${angle}deg)`
                    });

                    button.css('--rotation-angle', `${angle}deg`);

                });
            });


        })(jQuery);
    </script>
@endpush
