<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
    <!-- Bootstrap CSS -->
    <link href="{{ asset('assets/global/css/bootstrap.min.css') }}" rel="stylesheet">

    <link href="{{ asset('assets/global/css/all.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/line-awesome.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">

    <link href="{{ asset(activeTemplate(true) . 'css/icoonmoon.css') }}" rel="stylesheet">

    @stack('style-lib')
    <link href="{{ asset(activeTemplate(true) . 'css/main.css') }}" rel="stylesheet">
    <link href="{{ asset(activeTemplate(true) . 'css/custom.css') }}" rel="stylesheet">
    @stack('style')

    <link href="{{ asset(activeTemplate(true) . 'css/color.php') }}?color={{ gs('base_color') }}" rel="stylesheet">
</head>
@php echo loadExtension('google-analytics') @endphp

<body>

    @stack('fbComment')

    <!--==================== Preloader Start ====================-->
    @php $preloader = getContent('preloader.content', true)->data_values; @endphp
    <div class="preloader">
        <div class="preloader-inner">
            <img src="{{ frontendImage('preloader', @$preloader->image, '70x70') }}" alt="loader">
            <svg id="loader" viewbox="0 0 50 50">
                <path id="corners" d="m 0 12.5 l 0 -12.5 l 50 0 l 0 50 l -50 0 l 0 -37.5" />
            </svg>
        </div>
    </div>
    <!--==================== Preloader End ====================-->

    <!--==================== Overlay Start ====================-->
    <div class="body-overlay"></div>
    <!--==================== Overlay End ====================-->

    <!--==================== Sidebar Overlay End ====================-->
    <div class="sidebar-overlay"></div>
    <!--==================== Sidebar Overlay End ====================-->

    <!-- ==================== Scroll to Top End Here ==================== -->
    <a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>
    <!-- ==================== Scroll to Top End Here ==================== -->

    <main>
        @if (!request()->routeIs('maintenance'))
            @include('Template::partials.header')
        @endif
        @if (!request()->routeIs('home') && !request()->routeIs('maintenance'))
            @include('Template::partials.breadcrumb')
        @endif

        @yield('panel')

        @if (!request()->routeIs('maintenance'))
            @include('Template::partials.footer')
        @endif
    </main>

    @php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    @endphp
    @if (@$cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie'))
        <!-- cookies dark version start -->
        <div class="cookies-card text-center hide">
            <div class="cookies-card__icon bg--base">
                <i class="las la-cookie-bite"></i>
            </div>
            <p class="my-3 cookies-card__content">{{ @$cookie->data_values->short_desc }}
            <div class="cookies-card__btn flex-align justify-content-between gap-4">
                <a class="btn btn-outline--base" href="{{ route('cookie.policy') }}"
                    target="_blank">@lang('Learn More')</a>
                <a class="btn btn--base policy" href="javascript:void(0)">@lang('Accept All')</a>
            </div>
        </div>
        <!-- cookies dark version end -->
    @endif

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="{{ asset('assets/global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>

    @stack('script-lib')

    <script src="{{ asset(activeTemplate(true) . 'js/main.js') }}"></script>

    @php echo loadExtension('tawk-chat') @endphp

    @include('partials.notify')

    @if (gs('pn'))
        @include('partials.push_script')
    @endif
    @stack('script')

    <script>
        (function($) {
            "use strict";

            $(".langSel").on("click", function() {
                let code = $(this).data('code');
                window.location.href = "{{ route('home') }}/change/" + code;
            });

            $('.policy').on('click', function() {
                $.get('{{ route('cookie.accept') }}', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {
                var elementType = $(element);
                if (elementType.attr('type') != 'checkbox') {
                    if (element.hasAttribute('required')) {
                        $(element).closest('.form-group').find('label').addClass('required');
                    }
                }
            });

            let disableSubmission = false;
            $('.disableSubmission').on('submit', function(e) {
                if (disableSubmission) {
                    e.preventDefault()
                } else {
                    disableSubmission = true;
                }
            });


            $('.select2').each(function(index, element) {
                $(element).select2();
            });

        })(jQuery);
    </script>

</body>

</html>
