@extends('Template::layouts.frontend')
@section('content')
    @php
        $contact = getContent('contact_us.content', true)->data_values;
    @endphp
    <section class="py-120">
        <div class="container">
            <div class="row justify-content-center gy-4 pb-60">
                <div class="col-md-6 col-xl-4">
                    <div class="contact-info-card">
                        <div class="contact-info-card__icon">
                            <i class="icon-map"></i>
                        </div>
                        <div class="contact-info-card__content">
                            <h6 class="contact-info-card__title">@lang('Office Address')</h6>
                            <p class="contact-info-card__link">
                                {{ __($contact?->address_location) }}
                                </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="contact-info-card">
                        <div class="contact-info-card__icon">
                            <i class="icon-email-2"></i>
                        </div>
                        <div class="contact-info-card__content">
                            <h6 class="contact-info-card__title">@lang('Email Address')</h6>
                            <a class="contact-info-card__link"
                                href="mailto:{{ $contact?->email_address }}">{{ __($contact?->email_address) }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-xl-4">
                    <div class="contact-info-card">
                        <div class="contact-info-card__icon">
                            <i class="icon-call"></i>
                        </div>
                        <div class="contact-info-card__content">
                            <h6 class="contact-info-card__title">@lang('Phone Number')</h6>
                            <a class="contact-info-card__link"
                                href="tel:{{ $contact?->contact_number }}">{{ __($contact?->contact_number) }}</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row flex-lg-row-reverse gy-4">
                <div class="col-lg-6">
                    <div class="contact-form">
                        <form class="verify-gcaptcha" method="post">
                            @csrf

                            <div class="row g-3 g-xl-4">
                                <div class="col-sm-6">
                                    <input class="form--control" name="name" type="text"
                                        value="{{ old('name', $user?->fullname) }}" placeholder="@lang('Enter Fullname')"
                                        @if ($user && $user->profile_complete) readonly @endif required>
                                </div>
                                <div class="col-sm-6">
                                    <input class="form--control" name="email" type="email"
                                        value="{{ old('email', $user?->email) }}" placeholder="@lang('Enter Email Address')"
                                        @if ($user) readonly @endif required>
                                </div>
                                <div class="col-sm-12">
                                    <input class="form--control" name="subject" type="text" value="{{ old('subject') }}"
                                        placeholder="@lang('Enter Subject')" required>
                                </div>
                                <div class="col-lg-12">
                                    <textarea class="form--control" name="message" placeholder="@lang('Write Your Message')">{{ old('message') }}</textarea>
                                </div>

                                <x-captcha />

                                <div class="col-lg-12">
                                    <button class="btn btn--base w-100"><i class="lab la-telegram"></i>
                                        @lang('Send Messages')</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="contact-map">
                        <iframe src="{{ $contact->map_url }}" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if (isset($sections->secs) && $sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif
@endsection


@push('style')
    <style>
        .form--control:disabled,
        .form--control[readonly] {
            background-color: hsl(236.47deg 10.81% 40.64% / 80%) !important;
            opacity: 1;
            border: 0;
            color: #e3ebdd47 !important;
        }
    </style>
@endpush
