@extends('Template::layouts.frontend')

@section('content')
    <section class="py-120">
        <div class="container">
            <div class="row g-3 g-sm-4">
                @foreach ($blogs as $blog)
                    <div class="col-sm-6 col-lg-4">
                        <div class="blog-item">
                            <div class="blog-item__wrapper">
                                <div class="blog-item__img">
                                    <img src="{{ frontendImage('blog', 'thumb_' . $blog?->data_values?->image, '380x265') }}"
                                        alt="blog">
                                </div>
                                <div class="blog-item__content">
                                    <div class="blog-item-info">
                                        <div class="blog-item-info__img">
                                            <img src="{{ asset(activeTemplate(true) . 'images/shape/calendar.png') }}"
                                                alt="icon">
                                        </div>
                                        <div class="blog-item-info__content">
                                            <p class="blog-item-info__name">@lang('Posted on')</p>
                                            <p class="blog-item-info__time">
                                                {{ showDateTime($blog?->created_at, 'd, M Y') }}
                                            </p>
                                        </div>
                                    </div>
                                    <h6 class="blog-item__title">
                                        <a
                                            href="{{ route('blog.details', $blog?->slug) }}">{{ __(strLimit(@$blog->data_values->title, 80)) }}</a>
                                    </h6>
                                    <p class="blog-item__auth">@lang('By') {{ __($blog?->data_values?->author) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <nav class="pt-60">
                @if ($blogs->hasPages())
                    {{ paginateLinks($blogs) }}
                @endif
            </nav>
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif

@endsection
