@extends('Template::layouts.frontend')
@section('content')
    <section class="py-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="blog-item style-two">
                        <div class="blog-item__wrapper">
                            <div class="blog-item__img">
                                <img src="{{ frontendImage('blog', $blog?->data_values?->image, '728x465') }}" alt="image">
                            </div>
                            <div class="blog-item__content">
                                <div class="blog-item-info">
                                    <div class="blog-item-info__img">
                                        <img src="{{ asset(activeTemplate(true) . 'images/shape/calendar.png') }}"
                                            alt="icon">
                                    </div>
                                    <div class="blog-item-info__content">
                                        <p class="blog-item-info__name">@lang('Posted on')</p>
                                        <p class="blog-item-info__time"> {{ showDateTime($blog->created_at, 'd, M Y') }}</p>
                                    </div>
                                </div>
                                <h5 class="blog-item__title">
                                    {{ __(@$blog->data_values->title) }}
                                </h5>
                                <p class="blog-item__auth">@lang('By') {{ __(@$blog->data_values->author) }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="blog-content">
                        @php echo @$blog->data_values->description @endphp
                    </div>

                    <div class="comment-item-block">
                        <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                    </div>
                    <div class="mt-4">
                        <ul class="post__share">
                            <li data-bs-toggle="tooltip" title="@lang('Facebook')">
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}"
                                    target="_blank">
                                    <i class="lab la-facebook-f"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('X')">
                                <a href="https://twitter.com/share?url={{ url()->current() }}" target="_blank">
                                    <i class="fa-brands fa-x-twitter"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('LinkedIn')">
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ url()->current() }}"
                                    target="_blank">
                                    <i class="lab la-linkedin-in"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Reddit')">
                                <a href="http://www.reddit.com/submit?url={{ url()->current() }}" target="_blank">
                                    <i class="lab la-reddit"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Pinterest')">
                                <a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(frontendImage('blog', @$blog->data_values->image, '728x465')) }}&description={{ urlencode(@$blog->data_values->description) }}"
                                    target="_blank">
                                    <i class="fab fa-pinterest"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('WhatsApp')">
                                <a href="https://wa.me/?text={{ urlencode(url()->current()) }}" target="_blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                            </li>
                            <li data-bs-toggle="tooltip" title="@lang('Telegram')">
                                <a href="https://t.me/share/url?url={{ urlencode(url()->current()) }}&text={{ urlencode(@$blog->data_values->title) }}"
                                    target="_blank">
                                    <i class="fab fa-telegram"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title">@lang('Latest Blogs') </h5>
                            @forelse ($recentBlogs as $blog)
                                <div class="blog-sidebar__content">
                                    <div class="latest-blog">
                                        <div class="latest-blog__thumb">
                                            <a href="{{ route('blog.details', $blog->slug) }}"><img class="fit-image"
                                                    src="{{ frontendImage('blog', 'thumb_' . @$blog->data_values->image, '380x265') }}"
                                                    alt=""></a>
                                        </div>
                                        <div class="latest-blog__content">
                                            <h6 class="latest-blog__title"> <a
                                                    href="{{ route('blog.details', $blog->slug) }}">{{ __(strLimit(@$blog->data_values->title, 80)) }}</a>
                                            </h6>
                                            <div class="product-card-auth">
                                                <div class="product-card-auth__right">
                                                    <p class="product-card-auth__name">
                                                        @lang('By') {{ __(@$blog->data_values->author) }}
                                                        <span class="verify">
                                                            <i class="icon-verify"><span class="path1"></span><span
                                                                    class="path2"></span></i>
                                                        </span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                @include('Template::partials.empty', [
                                    'message' => 'Latest blog not found!',
                                ])
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush
