@php
    $perTreePriceAmount = @$project->per_tree_amount ? getAmount(@$project->per_tree_amount) : '';
@endphp

<form action="{{ route('admin.project.store', @$project->id) }}" method="POST" enctype="multipart/form-data">
    @csrf
    <input name="step" type="hidden" value="{{ request()->step }}">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label>@lang('Image')</label>
                <x-image-uploader class="w-100" type="project" image="{{ @$project->image }}" :required=false />
            </div>

            <div class="form-group">
                <label>@lang('About') <span class="text--danger">*</span></label>
                <textarea class="form-control nicEdit" name="about" rows="21">{{ old('about', @$project->about) }}</textarea>
            </div>

            <div class="form-group">
                <label for="">@lang('Featured')</label>
                <input name="featured" data-width="100%" data-onstyle="-success" data-offstyle="-danger"
                    data-bs-toggle="toggle" data-on="@lang('Yes')" data-off="@lang('No')" type="checkbox"
                    {{ old('featured', @$project->featured) ? 'checked' : '' }}>
            </div>
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Name')
                            <a href="javascript:void(0)" class="buildSlug">
                                <small><i class="las la-link"></i> @lang('Make Slug')</small>
                            </a>
                        </label>
                        <input class="form-control" name="name" type="text"
                            value="{{ old('name', @$project->name) }}" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="form-group">
                            <div class="d-flex justify-content-between">
                                <label> @lang('Slug')</label>
                                <div class="slug-verification d-none"></div>
                            </div>
                            <input type="text" class="form-control" name="slug"
                                value="{{ old('slug', @$project->slug) }}" required>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Per Tree Amount')</label>
                        <div class="input-group">
                            <input class="form-control" name="per_tree_amount" type="number"
                                value="{{ old('per_tree_amount', @$perTreePriceAmount) }}" step="any" required>
                            <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Total Quantity')</label>
                        <div class="input-group">
                            <input class="form-control" name="total_quantity" type="number"
                                value="{{ old('total_quantity', @$project->total_quantity) }}" required>
                            <span class="input-group-text">@lang('Qty')</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Investment Goal Amount')</label>
                        <div class="input-group">
                            <input class="form-control" name="investment" type="number"
                                value="{{ old('investment', getAmount(@$project->investment)) }}" step="any"
                                required readonly>
                            <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Minimum Invest')</label>
                        <div class="input-group">
                            <input class="form-control" name="minimum_quantity" type="number"
                                value="{{ old('minimum_quantity', @$project->minimum_quantity) }}" required>
                            <span class="input-group-text">@lang('Qty')</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Maximum Invest')</label>
                        <div class="input-group">
                            <input class="form-control" name="maximum_quantity" type="number"
                                value="{{ old('maximum_quantity', @$project->maximum_quantity) }}" required>
                            <span class="input-group-text">@lang('Qty')</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Invest End Date') <i class="las la-info-circle" data-bs-toggle="tooltip"
                                title="@lang("Please ensure that the 'Invest End Date' does not exceed the 'Harvest Time.' Double-check the calculation for accuracy.")"></i></label>
                        <input class="datepicker-here form-control bg--white pe-2 date-range" name="invest_end_date"
                            type="text" value="{{ old('invest_end_date', @$project->invest_end_date) }}" required
                            autocomplete="off">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Harvest Time') <small data-bs-toggle="tooltip" title="@lang('How many months will be needed to successfully produce this project from the Invest End Date.')"> <i
                                    class="las la-info-circle"></i></small></label>
                        <div class="input-group">
                            <input class="form-control" name="harvest_time" type="number"
                                value="{{ old('harvest_time', @$project->harvest_time) }}" required>
                            <span class="input-group-text">@lang('Months')</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Video Link') <i class="las la-info-circle" data-bs-toggle="tooltip"
                                title="@lang('Youtube embeded video link, For proof!')"></i></label>
                        <input class="form-control" name="video_link" type="text"
                            value="{{ old('video_link', @$project->video_link) }}">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Interest Interval Time')</label>
                        <select class="form-control select2" name="time_setting_id" required>
                            <option value="" selected disabled>@lang('Select One')</option>
                            @foreach ($times as $time)
                                <option value="{{ $time->id }}"
                                    {{ old('time_setting_id', @$project->time_setting_id) == $time->id ? 'selected' : '' }}>
                                    {{ __($time->name) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Interest Type')</label>
                        <select class="form-control select2" name="interest_type"
                            data-minimum-results-for-search="-1" required>
                            <option value="1"
                                {{ old('interest_type', @$project->interest_type) == 1 ? 'selected' : '' }}>
                                @lang('Percent')</option>
                            <option value="2"
                                {{ old('interest_type', @$project->interest_type) == 2 ? 'selected' : '' }}>
                                @lang('Fixed')</option>
                        </select>
                    </div>
                </div>

                <div class="row manage-interest-fields"></div>


                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Crop Duration') <small data-bs-toggle="tooltip" title="@lang('Enter the number of years until the crop is fully grown or completed.')"> <i
                                    class="las la-info-circle"></i></small></label>
                        <div class="input-group">
                            <input class="form-control" name="crop_duration" type="number"
                                value="{{ old('crop_duration', @$project->crop_duration) }}" required>
                            <span class="input-group-text">@lang('Years')</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('Return Type')</label>
                        <select class="form-control select2" name="return_type" data-minimum-results-for-search="-1"
                            required>
                            <option value="1"
                                {{ old('return_type', @$project->lifetime) == 1 ? 'selected' : '' }}>@lang('Lifetime')
                            </option>
                            <option value="2"
                                {{ old('return_type', @$project->lifetime) == 2 ? 'selected' : '' }}>@lang('Repeat')
                            </option>
                        </select>
                    </div>
                </div>

                <div class="row manage-return-fields"></div>

                <div class="col-lg-12 pt-3">
                    <div class="form-group">
                        <label>@lang('Overview') <span class="text--danger">*</span></label>
                        <textarea class="form-control nicEdit" name="overview" rows="5">{{ old('overview', @$project->overview) }}</textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
    </div>
</form>
