@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Project Name')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Quantity')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Should Pay')</th>
                                    <th>@lang('Paid')</th>
                                    <th>@lang('Status')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invests as $invest)
                                    <tr>
                                        <td>{{ __($invest->project->name) }}</td>
                                        <td>
                                            <span class="fw-bold">{{ $invest->user->fullname }}</span>
                                            <br>
                                            <span class="small"> <a
                                                    href="{{ route('admin.users.detail', $invest->user->id) }}"><span>@</span>{{ $invest->user->username }}</a>
                                            </span>
                                        </td>
                                        <td>{{ $invest->quantity }} @lang('Pcs')</td>
                                        <td>{{ showAmount($invest->amount) }}</td>
                                        <td>{{ $invest->should_pay != -1 ? showAmount($invest->should_pay) : '**' }}</td>
                                        <td>{{ showAmount($invest->paid) }}</td>
                                        <td>
                                            @if ($invest->status == Status::INVEST_RUNNING)
                                                <span class="badge badge--success">@lang('Running')</span>
                                            @elseif($invest->status == Status::INVEST_CANCELLED)
                                                <span class="badge badge--danger">@lang('Canceled')</span>
                                            @else
                                                <span class="badge badge--dark">@lang('Closed')</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($invests->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($invests) }}
                    </div>
                @endif
            </div><!-- card end -->
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.project.index') }}" />
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.cancelBtn').on('click', function() {
                let modal = $('#cancelModal');
                $('[name=invest_id]').val($(this).data('invest_id'));
                modal.modal('show');
            });
        })(jQuery)
    </script>
@endpush
