@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link @if ($step == 1) active @endif"
                            href="{{ isset($project) ? route('admin.project.edit', $project->id) . '?step=1' : route('admin.project.create') . '?step=1' }}">
                            <i class="las la-cogs"></i>
                            @lang('Project Configuration')
                        </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link @if ($step == 2) active @endif"
                            href="{{ isset($project) ? route('admin.project.edit', $project->id) . '?step=2' : 'javascript:void(0);' }}">
                            <i class="las la-question-circle"></i>
                            @lang("FAQ's")
                        </a>
                    </li>
                </ul>
                <div class="tab-content my-4">
                    @if ($step == 1)
                        @include('admin.project.step_one')
                    @elseif ($step == 2)
                        @include('admin.project.step_two')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@php
    $fixedInterestAmount = @$project->fixed_interest ? getAmount(@$project->fixed_interest) : '';
@endphp

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.project.index') }}" />
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/daterangepicker.min.js') }}"></script>
@endpush

@push('style-lib')
    <link type="text/css" href="{{ asset('assets/admin/css/daterangepicker.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script>
        (function($) {
            "use strict"

            $('.datepicker-here').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                autoUpdateInput: false,
                minDate: moment().add(1, 'days'),
                locale: {
                    format: 'YYYY-MM-DD'
                }
            });

            $('.datepicker-here').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD'));
            });

            $('.datepicker-here').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });

            $('[name=per_tree_amount]').on('input', function() {
                let totalQuantity = parseFloat($('[name=total_quantity]').val());
                let perTreeAmount = parseFloat($(this).val());
                updateInvestmentAmount(totalQuantity, perTreeAmount);
            });

            $('[name=total_quantity]').on('input', function() {
                let perTreeAmount = parseFloat($('[name=per_tree_amount]').val());
                let totalQuantity = parseFloat($(this).val());
                updateInvestmentAmount(totalQuantity, perTreeAmount);
            });

            function updateInvestmentAmount(quantity, pricePerTree) {
                let investmentAmount = quantity * pricePerTree;
                $('[name=investment]').val(investmentAmount.toFixed(2));
            }


            function getInterestType(type) {
                if (type == 1) {
                    var html = `
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('From Minimum Interest')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="minimum_interest" type="number" value="{{ old('minimum_interest', @$project->minimum_interest) }}" step="any" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                               <div class="form-group">
                                    <label>@lang('To Maximum Interest')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="maximum_interest" type="number" value="{{ old('maximum_interest', @$project->maximum_interest) }}" step="any" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            `;
                } else {
                    var html = `
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Fixed Interest')</label>
                                    <div class="input-group">
                                        <input class="form-control" name="fixed_interest" type="number" value="{{ old('fixed_interest', @$fixedInterestAmount) }}" step="any" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            `;
                }
                $('.manage-interest-fields').html(html);
            }

            function getReturnType(type) {

                if (type != 1) {
                    var html = `
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="required">@lang('Repeat Times')</label>
                                    <input class="form-control" name="repeat_time" type="number" value="{{ old('repeat_time', @$project->repeat_time) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                               <div class="form-group">
                                    <label>@lang('Capital back')</label>
                                    <select class="form-control select2" name="capital_back" required>
                                        <option value="1" {{ old('capital_back', @$project->capital_back) == 1 ? 'selected' : '' }}>@lang('Yes')</option>
                                        <option value="0" {{ old('capital_back', @$project->capital_back) == 0 ? 'selected' : '' }}>@lang('No')</option>
                                    </select>
                                </div>
                            </div>
                            `;
                    $('.manage-return-fields').html(html);
                    //reinitialize-select-2
                    $('.select2').each(function(index, element) {
                        $(element).select2();
                    });

                } else {
                    $('.manage-return-fields').html('');
                }
            }

            // Initial setup
            getInterestType($('[name=interest_type]').val());
            getReturnType($('[name=return_type]').val());

            // Event listeners
            $('[name=interest_type]').on("change", function() {
                getInterestType($(this).val());
            });

            $('[name=return_type]').on("change", function() {
                getReturnType($(this).val());
            });

            // Faqs
            $('.addNewFAQ').on('click', function() {
                $(".addFaqArea").before(`
                <div class="col-lg-4 col-md-6">
                    <div class="form-group">
                        <label>@lang('Question') <span class="text--danger">*</span></label>
                        <input type="text" name="question[]" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>@lang('Answer') <span class="text--danger">*</span></label>
                        <textarea name="answer[]" class="form-control" required></textarea>
                    </div>
                <button type="button" class="btn btn--danger btn--sm w-100 remove-btn">@lang('Remove')</button>
            </div>
                `)
                disableRemoveFaq()
            });
            $(document).on('click', '.remove-btn', function() {
                $(this).closest('div').remove();
                disableRemoveFaq()
            });

            function disableRemoveFaq() {
                if ($(document).find('.remove-btn').length == 1) {
                    $(document).find('.remove-btn').attr('disabled', true);
                } else {
                    $(document).find('.remove-btn').removeAttr('disabled');
                }
            }


            $('.buildSlug').on('click', function() {
                let closestForm = $(this).closest('form');
                let name = closestForm.find('[name=name]').val();
                closestForm.find('[name=slug]').val(name);
                closestForm.find('[name=slug]').trigger('input');
            });

            $('[name=slug]').on('input', function() {
                let closestForm = $(this).closest('form');
                closestForm.find('[type=submit]').addClass('disabled')
                let slug = $(this).val();
                slug = slug.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
                $(this).val(slug)
                if (slug) {
                    $('.slug-verification').removeClass('d-none');
                    $('.slug-verification').html(`
                        <small class="text--info"><i class="las la-spinner la-spin"></i> @lang('Verifying')</small>
                    `);
                    $.get("{{ route('admin.project.check.slug', @$project->id) }}", {
                        slug: slug
                    }, function(response) {
                        if (!response.exists) {
                            $('.slug-verification').html(`
                                <small class="text--success"><i class="las la-check"></i> @lang('Verified')</small>
                            `);
                            closestForm.find('[type=submit]').removeClass('disabled')
                        }
                        if (response.exists) {
                            $('.slug-verification').html(`
                                <small class="text--danger"><i class="las la-times"></i> @lang('Slug already exists')</small>
                            `);
                        }
                    });
                } else {
                    $('.slug-verification').addClass('d-none');
                }
            })


        })(jQuery);
    </script>
@endpush
