@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Investment') | @lang('Per Tree')</th>
                                    <th>@lang('Production Date')</th>
                                    <th>@lang('Interest')</th>
                                    <th>@lang('Interval')</th>
                                    <th>@lang('Is Dispatch') | @lang('Featured')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($projects as $project)
                                    <tr>
                                        <td><b>{{ __($project->name) }}</b> <br>
                                            <i class="las la-angle-double-right"></i> @lang('Quantity'):
                                            {{ $project->total_quantity }}
                                        </td>
                                        <td>
                                            <b> {{ showAmount($project->investment) }}</b>
                                            <br>
                                            <i class="las la-angle-double-right"></i>
                                            {{ showAmount($project->per_tree_amount) }}
                                        </td>
                                        <td>
                                            <span
                                                class="@if ($project->invest_end_date > now()) text--success @else text--danger @endif"
                                                data-bs-toggle="tooltip"
                                                title="{{ diffForHumans($project->invest_end_date) }}">@lang('Invest End'):
                                                {{ showDateTime($project->invest_end_date, 'd-m-Y') }}</span> <br>

                                            <span
                                                class="@if ($project->harvest_date > now()) text--primary @else text--danger @endif"
                                                data-bs-toggle="tooltip"
                                                title="{{ diffForHumans($project->harvest_date) }}">@lang('Harvest'):
                                                {{ showDateTime($project->harvest_date, 'd-m-Y') }}</span>

                                        </td>
                                        <td>
                                            @if ($project->interest_type == Status::FIXED)
                                                <span data-bs-toggle="tooltip"
                                                    title="@lang('Fixed return for invested amount of project')">{{ showAmount($project->fixed_interest) }}</span>
                                            @else
                                                <span>{{ showAmount($project->minimum_interest, currencyFormat: false) }}% -
                                                    {{ showAmount($project->maximum_interest, currencyFormat: false) }}%</span>
                                                <br>
                                                <span class="badge badge--primary" data-bs-toggle="tooltip"
                                                    title="@lang('Reserved interest for investor')">
                                                    {{ showAmount($project->reserved_interest, currencyFormat: false) }}%</span>
                                            @endif

                                        </td>
                                        <td>
                                            {{ @$project->timeSetting->name }}
                                            <br>
                                            <span class="badge badge--dark">{{ @$project->timeSetting->time }}
                                                @lang('Hours')</span>
                                        </td>
                                        <td>
                                            @if ($project->is_dispatch == Status::INTEREST_DISPATCH)
                                                <span class="badge badge--danger" data-bs-toggle="tooltip"
                                                    title="@lang('Dispatched project can\'t make edit action.')">@lang('Yes')</span>
                                            @else
                                                <span class="badge badge--info">@lang('No')</span>
                                            @endif
                                            @if ($project->featured == Status::YES)
                                                <span class="badge badge--success">@lang('Yes')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('No')</span>
                                            @endif

                                        </td>
                                        <td>
                                            @php echo  $project->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-outline--info btn--sm" data-bs-toggle="dropdown"
                                                    type="button" aria-expanded="false">
                                                    <i class="las la-ellipsis-v"></i>@lang('More')
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item text--danger dispatchBtn"
                                                        data-project="{{ $project }}"
                                                        data-action="{{ route('admin.project.interest.dispatch', $project->id) }}"
                                                        href="javascript:void(0)"
                                                        @if ($project->is_dispatch) data-bs-toggle="tooltip" title="@lang('Already dispatched, So you can\'t make edit action.')" @endif>
                                                        <i class="la la-folder-plus"></i> @lang('Dispatch')
                                                    </a>
                                                    <a class="dropdown-item text--info"
                                                        href="{{ route('admin.project.invest.history', $project->id) }}">
                                                        <i class="la la-history"></i> @lang('Invest History')
                                                    </a>
                                                    <a class="dropdown-item text--info"
                                                        href="{{ route('admin.project.seo', $project->id) }}">
                                                        <i class="la la-cog"></i> @lang('SEO Setting')
                                                    </a>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>

    <div class="modal fade" id="dispatchModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Interest Dispatch Alert!')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST">
                    @csrf
                    <div class="modal-body">
                        <h5>@lang('Are you sure you want to dispatch this project? ')</h5>
                        <p>@lang('Once dispatched, interest will be automatically processed by the cron job.')</p>

                        <h5 class="py-2">@lang('Project'): <span class="project-name"></span></h5>

                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-start">
                                <div class="text--primary interest-label"></div>
                                <span class="text--primary interest-value"></span>
                            </li>
                        </ul>
                        <div class="percentageInput py-2"></div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Search by property" />
    <a class="btn btn-outline--primary" href="{{ route('admin.project.create') }}?step=1 "><i
            class="las la-plus"></i>@lang('Add New')</a>
@endpush

@push('style')
    <style>
        .spinner-grow {
            --bs-spinner-width: 10px !important;
            --bs-spinner-height: 10px !important;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $(document).on('click', '.dispatchBtn', function() {
                var dispatch = $('#dispatchModal');
                let data = $(this).data();
                let curText = `{{ gs('cur_text') }}`;

                let interestInputHtml = `
                    <div class="form-group">
                        <label>@lang('Reserved Interest Percent') <span class="text--danger">*</label>
                        <div class="input-group">
                            <input class="form-control" name="interest" value"{{ old('interest') }}" type="number" step="0.01" required>
                            <span class="input-group-text">%</span>
                        </div>
                    </div>`;

                // Set up modal content based on interest type
                if (data.project.interest_type == 1) {
                    $('.percentageInput').html(interestInputHtml);
                    dispatch.find('.interest-label').text(`@lang('Percent')`);
                    dispatch.find('.interest-value').text(
                        `${data.project.minimum_interest}% @lang('to') ${data.project.maximum_interest}%`
                        );
                } else {
                    $('.percentageInput').empty();
                    let fixedInterest = parseFloat(data.project.fixed_interest).toFixed(2);
                    dispatch.find('.interest-label').text(`@lang('Fixed')`);
                    dispatch.find('.interest-value').text(`${fixedInterest} ${curText}`);
                }

                dispatch.find('.project-name').text(data.project.name);
                dispatch.find('.question').text(data.question);

                dispatch.find('form').attr('action', data.action);
                dispatch.modal('show');
            });

        })(jQuery);
    </script>
@endpush
