<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Builder;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use GlobalStatus;

    protected $casts = [
        'faqs'        => 'object',
        'seo_content' => 'object',
    ];

    public function invests()
    {
        return $this->hasMany(Invest::class);
    }

    public function timeSetting()
    {
        return $this->belongsTo(TimeSetting::class);
    }

    public function scopeEligibleToInvest(Builder $query)
    {
        return $query->where('is_dispatch', Status::INTEREST_NOT_DISPATCH)
                     ->where(function ($query) {
                         $query->whereDoesntHave('invests')
                               ->orWhereHas('invests', function ($subQuery) {
                                   $subQuery->selectRaw('SUM(amount) as total_amount')
                                            ->havingRaw('total_amount < projects.investment');
                               });
                     });
    }

}
