<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\CurlRequest;
use App\Lib\TreeInvestLab;
use App\Models\CronJob;
use App\Models\CronJobLog;
use App\Models\Invest;
use App\Models\Project;
use App\Models\Transaction;
use Carbon\Carbon;

class CronController extends Controller {
    public function cron() {
        $general            = gs();
        $general->last_cron = now();
        $general->save();

        $crons = CronJob::with('schedule');

        if (request()->alias) {
            $crons->where('alias', request()->alias);
        } else {
            $crons->where('next_run', '<', now())->where('is_running', Status::YES);
        }
        $crons = $crons->get();
        foreach ($crons as $cron) {
            $cronLog              = new CronJobLog();
            $cronLog->cron_job_id = $cron->id;
            $cronLog->start_at    = now();
            if ($cron->is_default) {
                $controller = new $cron->action[0];
                try {
                    $method = $cron->action[1];
                    $controller->$method();
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            } else {
                try {
                    CurlRequest::curlContent($cron->url);
                } catch (\Exception $e) {
                    $cronLog->error = $e->getMessage();
                }
            }
            $cron->last_run = now();
            $cron->next_run = now()->addSeconds((int) $cron->schedule->interval);
            $cron->save();

            $cronLog->end_at = $cron->last_run;

            $startTime         = Carbon::parse($cronLog->start_at);
            $endTime           = Carbon::parse($cronLog->end_at);
            $diffInSeconds     = $startTime->diffInSeconds($endTime);
            $cronLog->duration = $diffInSeconds;
            $cronLog->save();
        }
        if (request()->target == 'all') {
            $notify[] = ['success', 'Cron executed successfully'];
            return back()->withNotify($notify);
        }
        if (request()->alias) {
            $notify[] = ['success', keyToTitle(request()->alias) . ' executed successfully'];
            return back()->withNotify($notify);
        }
    }

    public function interest() {
        try {
            $now     = Carbon::now();
            $general = gs();

            $invests = Invest::with(['project.timeSetting', 'user'])
                ->where('status', Status::INVEST_RUNNING)
                ->where('next_time', '<=', $now)
                ->whereHas('project', function ($query) {
                    $query->active()->whereHas('timeSetting', function ($subQuery) {
                        $subQuery->active();
                    });
                })
                ->orderBy('last_time')->take(100)->get();

            foreach ($invests as $invest) {
                $hours = (int) $invest->project?->timeSetting->time;
                $next  = $now->addHours($hours)->toDateTimeString();
                $user  = $invest->user;

                $invest->return_rec_time += 1;
                $invest->paid += $invest->interest;
                $invest->should_pay -= $invest->period > 0 ? $invest->interest : 0;
                $invest->next_time = $next;
                $invest->last_time = now();

                // Add Return Amount to user's Interest Balance
                $user->balance += $invest->interest;
                $user->save();

                $trx = getTrx();

                // Create The Transaction for Interest Back
                $transaction               = new Transaction();
                $transaction->user_id      = $user->id;
                $transaction->invest_id    = $invest->id;
                $transaction->amount       = $invest->interest;
                $transaction->charge       = 0;
                $transaction->post_balance = $user->balance;
                $transaction->trx_type     = '+';
                $transaction->trx          = $trx;
                $transaction->remark       = 'interest';
                $transaction->details      = showAmount($invest->interest) . ' interest from ' . @$invest->project->name;
                $transaction->save();

                if ($general->invest_return_commission == Status::ENABLE) {
                    $commissionType = 'invest_return_commission';
                    TreeInvestLab::levelCommission($user, $invest->interest, $commissionType, $trx);
                }

                // Complete the investment if user get full amount as project
                if ($invest->return_rec_time >= $invest->period && $invest->period != -1) {
                    $invest->status = Status::INVEST_CLOSED; // Change Status so he do not get any more return

                    if ($invest->capital_status == Status::CAPITAL_BACK) {
                        TreeInvestLab::capitalReturn($invest);
                    }
                }
                $invest->save();

                notify($user, 'INTEREST', [
                    'trx'          => $invest->trx,
                    'amount'       => showAmount($invest->interest),
                    'project_name' => @$invest->project->name,
                    'post_balance' => showAmount($user->balance),
                ]);
            }
        } catch (\Throwable $th) {
            throw new \Exception($th->getMessage());
        }
    }

    public function projectCrops() {
        try {
            $now = Carbon::now();

            $projects = Project::active()->with('invests.user', 'invests.project')->where('crop_date', '<', $now)->whereHas('invests', function ($query) {
                $query->where('status', Status::INVEST_RUNNING);
            })->orderBy('id')->take(100)->get();

            foreach ($projects as $project) {
                $project->status = Status::DISABLE;
                $project->save();

                foreach ($project->invests as $invest) {
                    $invest->status = Status::INVEST_CLOSED;
                    $invest->save();

                    notify($invest->user, 'PROJECT_TERMINATE', [
                        'project_name' => $invest->project->name,
                    ]);
                }
            }
        } catch (\Throwable $th) {
            throw new \Exception($th->getMessage());
        }
    }
}
