"use strict";
(function ($) {
  // ==========================================
  //      Start Document Ready function
  // ==========================================
  $(document).ready(function () {
    function fixHeader() {
      if ($(window).scrollTop() >= 50) {
        $(".header").addClass("fixed-header");
      } else {
        $(".header").removeClass("fixed-header");
      }
    }

    $(window).on("scroll", function () {
      fixHeader();
    });

    fixHeader();

    // // ========================= Header Sticky Js End===================

    // //============================ Scroll To Top Icon Js Start =========
    var btn = $(".scroll-top");

    $(window).scroll(function () {
      if ($(window).scrollTop() > 300) {
        btn.addClass("show");
      } else {
        btn.removeClass("show");
      }
    });

    btn.on("click", function (e) {
      e.preventDefault();
      $("html, body").animate(
        {
          scrollTop: 0,
        },
        "300"
      );
    });

    // ========================== Small Device Header Menu On Click Dropdown menu collapse Stop Js Start =====================
    $(".dropdown-item").on("click", function () {
      $(this).closest(".dropdown-menu").addClass("d-block");
    });
    // ========================== Small Device Header Menu On Click Dropdown menu collapse Stop Js End =====================

    // ========================== Add Attribute For Bg Image Js Start =====================
    $(".bg-img").css("background", function () {
      var bg = "url(" + $(this).data("background-image") + ")";
      return bg;
    });
    // ========================== Add Attribute For Bg Image Js End =====================

    // ========================== add active class to ul>li top Active current page Js Start =====================
    function dynamicActiveMenuClass(selector) {
      let fileName = window.location.pathname.split("/").reverse()[0];
      selector.find("li").each(function () {
        let anchor = $(this).find("a");
        if ($(anchor).attr("href") == fileName) {
          $(this).addClass("active");
        }
      });
      // if any li has active element add class
      selector.children("li").each(function () {
        if ($(this).find(".active").length) {
          $(this).addClass("active");
        }
      });
      // if no file name return
      if ("" == fileName) {
        selector.find("li").eq(0).addClass("active");
      }
    }
    if ($("ul.sidebar-menu-list").length) {
      dynamicActiveMenuClass($("ul.sidebar-menu-list"));
    }
    // ========================== add active class to ul>li top Active current page Js End =====================

    // ================== Password Show Hide Js Start ==========

    $(".toggle-password").on("click", function () {
      var input = $(this).siblings(
        'input[type="password"], input[type="text"]'
      );
      if (input.attr("type") === "password") {
        input.attr("type", "text");
        $(this).removeClass("fa-eye-slash").addClass("fa-eye");
      } else {
        input.attr("type", "password");
        $(this).removeClass("fa-eye").addClass("fa-eye-slash");
      }
    });
    // =============== Password Show Hide Js End =================

    // ========================= Slick Slider Js Start ==============

    var tabSliderCalled = false;

    function tabSlider() {
      tabSliderCalled = true;
    }

    if ($(".nav-link-slider").hasClass("active")) {
      if (!tabSliderCalled) {
        tabSlider();
      }
    }

    $(".nav-link-slider").on("click", function () {
      if ($(this).hasClass("active")) {
        if (!tabSliderCalled) {
          tabSlider();
        }
      }
    });

    // ========================= Slick Slider Js End ===================

    // ========================= brand Slider Js Start ===============

    // ========================= brand Slider Js End ===================

    // Sidebar Icon & Overlay js
    $(".dashboard-body__bar-icon").on("click", function () {
      $(".sidebar-menu").addClass("show-sidebar");
      $(".sidebar-overlay").addClass("show");
    });
    $(".sidebar-menu__close, .sidebar-overlay").on("click", function () {
      $(".sidebar-menu").removeClass("show-sidebar");
      $(".sidebar-overlay").removeClass("show");
    });
    // Sidebar Icon & Overlay js
    // ===================== Sidebar Menu Js End =================

    // ==================== Dashboard User Profile Dropdown Start ==================
    $(".user-info__button").on("click", function () {
      $(".user-info-dropdown").toggleClass("show");
    });
    $(".user-info__button").attr("tabindex", -1).focus();

    $(".user-info__button").on("focusout", function () {
      $(".user-info-dropdown").removeClass("show");
    });
    // ==================== Dashboard User Profile Dropdown End ==================
  });
  // ==========================================
  //      End Document Ready function
  // ==========================================

  // tab
  $(document).ready(function () {
    updateBar();
    $(".custom--tab .nav-link").on("click", function () {
      var width = $(this).outerWidth();
      var position = $(this).position().left;
      $(".tab__bar").css({
        width: width + "px",
        left: position + "px",
      });
      updateBar();
    });

    function updateBar() {
      var activeNavItem = $(".custom--tab .nav-link.active");
      if (activeNavItem.length > 0) {
        var width = activeNavItem.outerWidth();
        var position = activeNavItem.position().left;
        $(".tab__bar").css({
          width: width + "px",
          left: position + "px",
        });
      }
    }
  });

  $(".custom-radius").css({
    "margin-top": "25px",
  });

  $(document).on("click", ".has-dropdown > a", function () {
    $(".sidebar-submenu").slideUp(200);
    if ($(this).parent().hasClass("active")) {
      $(".has-dropdown").removeClass("active");
      $(this).parent().removeClass("active");
    } else {
      $(".has-dropdown").removeClass("active");
      $(this).next(".sidebar-submenu").slideDown(200);
      $(this).parent().addClass("active");
    }
  });
  // Sidebar Dropdown Menu End

  const curElement = {
    mainCurrency: $(".language-list"),
  };

  const mainCurrency = curElement.mainCurrency;
  const currencyItem = mainCurrency.children();

  currencyItem.each(function () {
    const innerItem = $(this);
    const languageText = innerItem.find(".language_text");
    const languageImage = innerItem.find("img");

    innerItem.on("click", function () {
      // Change the text
      $(".language__text").text(languageText.text());

      // Change the image
      const newImageSrc = languageImage.attr("src");
      $(".language__icon img").attr("src", newImageSrc);
    });
  });

  $(document).ready(function () {
    const text = $("#circle-text");
    const str = text.text();

    let strConvert = str.trim().split("");
    $.each(strConvert, function (i, currentItem) {
      let $span = $("<span></span>");
      $span.addClass("faq-circle__innertext");
      $span.html(currentItem);
      text.append($span);
      $span.css("transform", "rotate(" + 11 * i + "deg)");
    });
  });

  // comment
  $(document).ready(function () {
    $(".comment-item__reply").each(function (index, item) {
      $(item).on("click", function (event) {
        event.stopPropagation();
        $(".comment-item__reply").not($(this)).removeClass("active");
        $(this).toggleClass("active");
        $(".comment-form").not($(".comment-form").eq(index)).slideUp();
        $(".comment-form").eq(index).slideToggle();
      });
    });

    $(window).on("click", function (event) {
      if (!$(event.target).closest(".comment-form").length) {
        $(".comment-item__reply").removeClass("active");
        $(".comment-form").slideUp();
      }
    });
  });

  var tooltipTriggerList = [].slice.call(
    document.querySelectorAll("[title], [data-title], [data-bs-title]")
  );
  tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });

  $.each($("input, select, textarea"), function (i, element) {
    var elementType = $(element);
    if (
      elementType.attr("type") != "checkbox" &&
      element.hasAttribute("required")
    ) {
      $(element).closest(".form-group").find("label").addClass("required");
    }
  });

  $(".showFilterBtn").on("click", function () {
    $(".responsive-filter-card").slideToggle();
  });

  // table before

  //required
  $.each($("input, select, textarea"), function (i, element) {
    if (element.hasAttribute("required")) {
      $(element)
        .closest(".form-group")
        .find("label")
        .first()
        .addClass("required");
    }
  });
  //data-label of table-dynamic//
  Array.from(document.querySelectorAll("table")).forEach((table) => {
    let heading = table.querySelectorAll("thead tr th");
    Array.from(table.querySelectorAll("tbody tr")).forEach((row) => {
      Array.from(row.querySelectorAll("td")).forEach((column, i) => {
        column.colSpan == 100 ||
          column.setAttribute("data-label", heading[i].innerText);
      });
    });
  });

  $("#confirmationModal").addClass("custom--modal");
  $("#confirmationModal .modal-dialog").addClass(
    "modal-dialog-centered modal-sm"
  );
  $("#confirmationModal .btn--primary")
    .addClass("btn--sm btn--base")
    .removeClass("btn-sm btn--primary");
  $("#confirmationModal .btn--dark")
    .addClass("btn--sm btn--danger")
    .removeClass("btn-sm btn--dark");
  $("#confirmationModal .close").addClass("btn-close");

  // // ========================= lazy load gif End===================

  $(window).on("load", function () {
    // Fade out the preloader first
    $(".preloader").fadeOut(function () {
      // Start loading GIFs after preloader fades out
      $(".lazy-gif").each(function () {
        var gifImage = $(this);
        var gifSrc = gifImage.data("gif");

        // Check if the GIF is already cached
        var img = new Image();
        img.src = gifSrc;

        // Load the GIF once cached or immediately if already cached
        img.onload = function () {
          gifImage.attr("src", gifSrc);
        };
      });
    });
  });

  // // ========================= lazy load gif End===================
})(jQuery);
